import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { getOSMTileIndices } from './tile-2d-traversal';
var TILE_SIZE = 512;
var DEFAULT_EXTENT = [-Infinity, -Infinity, Infinity, Infinity];
export var urlType = {
  type: 'url',
  value: '',
  validate: function validate(value) {
    return typeof value === 'string' || Array.isArray(value) && value.every(function (url) {
      return typeof url === 'string';
    });
  },
  equals: function equals(value1, value2) {
    if (value1 === value2) {
      return true;
    }

    if (!Array.isArray(value1) || !Array.isArray(value2)) {
      return false;
    }

    var len = value1.length;

    if (len !== value2.length) {
      return false;
    }

    for (var i = 0; i < len; i++) {
      if (value1[i] !== value2[i]) {
        return false;
      }
    }

    return true;
  }
};
export function getURLFromTemplate(template, properties) {
  if (!template || !template.length) {
    return null;
  }

  if (Array.isArray(template)) {
    var index = Math.abs(properties.x + properties.y) % template.length;
    template = template[index];
  }

  return template.replace ? template.replace(/\{ *([\w_-]+) *\}/g, function (_, property) {
    return properties[property];
  }) : null;
}

function getBoundingBox(viewport, zRange, extent) {
  var bounds;

  if (zRange && zRange.length === 2) {
    var _zRange = _slicedToArray(zRange, 2),
        minZ = _zRange[0],
        maxZ = _zRange[1];

    var bounds0 = viewport.getBounds({
      z: minZ
    });
    var bounds1 = viewport.getBounds({
      z: maxZ
    });
    bounds = [Math.min(bounds0[0], bounds1[0]), Math.min(bounds0[1], bounds1[1]), Math.max(bounds0[2], bounds1[2]), Math.max(bounds0[3], bounds1[3])];
  } else {
    bounds = viewport.getBounds();
  }

  return [Math.max(bounds[0], extent[0]), Math.max(bounds[1], extent[1]), Math.min(bounds[2], extent[2]), Math.min(bounds[3], extent[3])];
}

function getTileIndex(_ref, scale) {
  var _ref2 = _slicedToArray(_ref, 2),
      x = _ref2[0],
      y = _ref2[1];

  return [x * scale / TILE_SIZE, y * scale / TILE_SIZE];
}

function getScale(z) {
  return Math.pow(2, z);
}

function osmTile2lngLat(x, y, z) {
  var scale = getScale(z);
  var lng = x / scale * 360 - 180;
  var n = Math.PI - 2 * Math.PI * y / scale;
  var lat = 180 / Math.PI * Math.atan(0.5 * (Math.exp(n) - Math.exp(-n)));
  return [lng, lat];
}

function tile2XY(x, y, z) {
  var scale = getScale(z);
  return [x / scale * TILE_SIZE, y / scale * TILE_SIZE];
}

export function tileToBoundingBox(viewport, x, y, z) {
  if (viewport.isGeospatial) {
    var _osmTile2lngLat = osmTile2lngLat(x, y, z),
        _osmTile2lngLat2 = _slicedToArray(_osmTile2lngLat, 2),
        west = _osmTile2lngLat2[0],
        north = _osmTile2lngLat2[1];

    var _osmTile2lngLat3 = osmTile2lngLat(x + 1, y + 1, z),
        _osmTile2lngLat4 = _slicedToArray(_osmTile2lngLat3, 2),
        east = _osmTile2lngLat4[0],
        south = _osmTile2lngLat4[1];

    return {
      west: west,
      north: north,
      east: east,
      south: south
    };
  }

  var _tile2XY = tile2XY(x, y, z),
      _tile2XY2 = _slicedToArray(_tile2XY, 2),
      left = _tile2XY2[0],
      top = _tile2XY2[1];

  var _tile2XY3 = tile2XY(x + 1, y + 1, z),
      _tile2XY4 = _slicedToArray(_tile2XY3, 2),
      right = _tile2XY4[0],
      bottom = _tile2XY4[1];

  return {
    left: left,
    top: top,
    right: right,
    bottom: bottom
  };
}

function getIdentityTileIndices(viewport, z, extent) {
  var bbox = getBoundingBox(viewport, null, extent);
  var scale = getScale(z);

  var _getTileIndex = getTileIndex([bbox[0], bbox[1]], scale),
      _getTileIndex2 = _slicedToArray(_getTileIndex, 2),
      minX = _getTileIndex2[0],
      minY = _getTileIndex2[1];

  var _getTileIndex3 = getTileIndex([bbox[2], bbox[3]], scale),
      _getTileIndex4 = _slicedToArray(_getTileIndex3, 2),
      maxX = _getTileIndex4[0],
      maxY = _getTileIndex4[1];

  var indices = [];

  for (var x = Math.floor(minX); x < maxX; x++) {
    for (var y = Math.floor(minY); y < maxY; y++) {
      indices.push({
        x: x,
        y: y,
        z: z
      });
    }
  }

  return indices;
}

export function getTileIndices(_ref3) {
  var viewport = _ref3.viewport,
      maxZoom = _ref3.maxZoom,
      minZoom = _ref3.minZoom,
      zRange = _ref3.zRange,
      extent = _ref3.extent,
      _ref3$tileSize = _ref3.tileSize,
      tileSize = _ref3$tileSize === void 0 ? TILE_SIZE : _ref3$tileSize;
  var z = Math.round(viewport.zoom + Math.log2(TILE_SIZE / tileSize));

  if (Number.isFinite(minZoom) && z < minZoom) {
    if (!extent) {
      return [];
    }

    z = minZoom;
  }

  if (Number.isFinite(maxZoom) && z > maxZoom) {
    z = maxZoom;
  }

  return viewport.isGeospatial ? getOSMTileIndices(viewport, z, zRange, extent || DEFAULT_EXTENT) : getIdentityTileIndices(viewport, z, extent || DEFAULT_EXTENT);
}
//# sourceMappingURL=utils.js.map