import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import { PathLayer } from '@deck.gl/layers';
var defaultProps = {
  trailLength: {
    type: 'number',
    value: 120,
    min: 0
  },
  currentTime: {
    type: 'number',
    value: 0,
    min: 0
  },
  getTimestamps: {
    type: 'accessor',
    value: null
  }
};

var TripsLayer = function (_PathLayer) {
  _inherits(TripsLayer, _PathLayer);

  function TripsLayer() {
    _classCallCheck(this, TripsLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(TripsLayer).apply(this, arguments));
  }

  _createClass(TripsLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var shaders = _get(_getPrototypeOf(TripsLayer.prototype), "getShaders", this).call(this);

      shaders.inject = {
        'vs:#decl': "uniform float trailLength;\nattribute float instanceTimestamps;\nattribute float instanceNextTimestamps;\nvarying float vTime;\n",
        'vs:#main-end': "vTime = instanceTimestamps + (instanceNextTimestamps - instanceTimestamps) * vPathPosition.y / vPathLength;\n",
        'fs:#decl': "uniform float trailLength;\nuniform float currentTime;\nvarying float vTime;\n",
        'fs:#main-start': "if(vTime > currentTime || vTime < currentTime - trailLength) {\n  discard;\n}\n",
        'fs:DECKGL_FILTER_COLOR': 'color.a *= 1.0 - (currentTime - vTime) / trailLength;'
      };
      return shaders;
    }
  }, {
    key: "initializeState",
    value: function initializeState(params) {
      _get(_getPrototypeOf(TripsLayer.prototype), "initializeState", this).call(this, params);

      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        timestamps: {
          size: 1,
          accessor: 'getTimestamps',
          shaderAttributes: {
            instanceTimestamps: {
              vertexOffset: 0
            },
            instanceNextTimestamps: {
              vertexOffset: 1
            }
          }
        }
      });
    }
  }, {
    key: "draw",
    value: function draw(params) {
      var _this$props = this.props,
          trailLength = _this$props.trailLength,
          currentTime = _this$props.currentTime;
      params.uniforms = Object.assign({}, params.uniforms, {
        trailLength: trailLength,
        currentTime: currentTime
      });

      _get(_getPrototypeOf(TripsLayer.prototype), "draw", this).call(this, params);
    }
  }]);

  return TripsLayer;
}(PathLayer);

export { TripsLayer as default };
TripsLayer.layerName = 'TripsLayer';
TripsLayer.defaultProps = defaultProps;
//# sourceMappingURL=trips-layer.js.map