"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = convertFunctions;

var _parseExpressionString = _interopRequireDefault(require("./parse-expression-string"));

var _syntacticSugar = require("../syntactic-sugar");

function hasFunctionIdentifier(value) {
  return typeof value === 'string' && value.startsWith(_syntacticSugar.FUNCTION_IDENTIFIER);
}

function trimFunctionIdentifier(value) {
  return value.replace(_syntacticSugar.FUNCTION_IDENTIFIER, '');
}

function convertFunctions(props, configuration) {
  var replacedProps = {};

  for (var propName in props) {
    var propValue = props[propName];
    var isFunction = hasFunctionIdentifier(propValue);

    if (isFunction) {
      propValue = trimFunctionIdentifier(propValue);
      propValue = (0, _parseExpressionString["default"])(propValue, configuration);
    }

    replacedProps[propName] = propValue;
  }

  return replacedProps;
}
//# sourceMappingURL=convert-functions.js.map