"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = parseExpressionString;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _get = require("../utils/get");

var _expressionEval = _interopRequireDefault(require("expression-eval"));

var cachedExpressionMap = {
  '-': function _(object) {
    return object;
  }
};

function parseExpressionString(propValue, configuration) {
  if (propValue in cachedExpressionMap) {
    return cachedExpressionMap[propValue];
  }

  var func;

  var ast = _expressionEval["default"].parse(propValue);

  if (!ast.right && !ast.left && ast.type === 'Identifier') {
    func = function func(row) {
      return (0, _get.get)(row, propValue);
    };
  } else {
    traverse(ast, function (node) {
      if (node.type === 'CallExpression') {
        throw new Error('Function calls not allowed in JSON expressions');
      }
    });

    func = function func(row) {
      return _expressionEval["default"].eval(ast, row);
    };
  }

  cachedExpressionMap[propValue] = func;
  return func;
}

function traverse(node, visitor) {
  if (Array.isArray(node)) {
    node.forEach(function (element) {
      return traverse(element, visitor);
    });
  } else if (node && (0, _typeof2["default"])(node) === 'object') {
    if (node.type) {
      visitor(node);
    }

    for (var key in node) {
      traverse(node[key], visitor);
    }
  }
}
//# sourceMappingURL=parse-expression-string.js.map