"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _parseExpressionString = _interopRequireDefault(require("./helpers/parse-expression-string"));

var _assert = _interopRequireDefault(require("./utils/assert"));

var _syntacticSugar = require("./syntactic-sugar");

var isObject = function isObject(value) {
  return value && (0, _typeof2["default"])(value) === 'object';
};

var JSONConfiguration = function () {
  function JSONConfiguration() {
    (0, _classCallCheck2["default"])(this, JSONConfiguration);
    this.typeKey = _syntacticSugar.TYPE_KEY;
    this.log = console;
    this.classes = {};
    this.reactComponents = {};
    this.enumerations = {};
    this.constants = {};
    this.convertFunction = convertFunction;

    this.preProcessClassProps = function (Class, props) {
      return props;
    };

    this.postProcessConvertedJson = function (json) {
      return json;
    };

    for (var _len = arguments.length, configurations = new Array(_len), _key = 0; _key < _len; _key++) {
      configurations[_key] = arguments[_key];
    }

    for (var _i = 0, _configurations = configurations; _i < _configurations.length; _i++) {
      var configuration = _configurations[_i];
      this.merge(configuration);
    }
  }

  (0, _createClass2["default"])(JSONConfiguration, [{
    key: "merge",
    value: function merge(configuration) {
      for (var key in configuration) {
        switch (key) {
          case 'layers':
          case 'views':
            Object.assign(this.classes, configuration[key]);
            break;

          default:
            if (key in this) {
              var value = configuration[key];
              this[key] = isObject(this[key]) ? Object.assign(this[key], value) : value;
            }

        }
      }
    }
  }, {
    key: "validate",
    value: function validate(configuration) {
      (0, _assert["default"])(!this.typeKey || typeof this.typeKey === 'string');
      (0, _assert["default"])(isObject(this.classes));
      return true;
    }
  }]);
  return JSONConfiguration;
}();

exports["default"] = JSONConfiguration;

function convertFunction(value, configuration) {
  return (0, _parseExpressionString["default"])(value, configuration);
}
//# sourceMappingURL=json-configuration.js.map