"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _assert = _interopRequireDefault(require("./utils/assert"));

var _jsonConfiguration = _interopRequireDefault(require("./json-configuration"));

var _instantiateClass = require("./helpers/instantiate-class");

var _syntacticSugar = require("./syntactic-sugar");

var _parseJson = _interopRequireDefault(require("./helpers/parse-json"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var isObject = function isObject(value) {
  return value && (0, _typeof2["default"])(value) === 'object';
};

var JSONConverter = function () {
  function JSONConverter(props) {
    (0, _classCallCheck2["default"])(this, JSONConverter);
    this.log = console;
    this.configuration = {};

    this.onJSONChange = function () {};

    this.json = null;
    this.convertedJson = null;
    this.setProps(props);
  }

  (0, _createClass2["default"])(JSONConverter, [{
    key: "finalize",
    value: function finalize() {}
  }, {
    key: "setProps",
    value: function setProps(props) {
      if ('configuration' in props) {
        this.configuration = props.configuration instanceof _jsonConfiguration["default"] ? props.configuration : new _jsonConfiguration["default"](props.configuration);
      }

      if ('onJSONChange' in props) {
        this.onJSONChange = props.onJSONChange;
      }
    }
  }, {
    key: "mergeConfiguration",
    value: function mergeConfiguration(config) {
      this.configuration.merge(config);
    }
  }, {
    key: "convert",
    value: function convert(json) {
      if (!json || json === this.json) {
        return this.convertedJson;
      }

      this.json = json;
      var parsedJSON = (0, _parseJson["default"])(json);
      var convertedJson = convertJSON(parsedJSON, this.configuration);
      convertedJson = this.configuration.postProcessConvertedJson(convertedJson);
      this.convertedJson = convertedJson;
      return convertedJson;
    }
  }, {
    key: "convertJson",
    value: function convertJson(json) {
      return this.convert(json);
    }
  }]);
  return JSONConverter;
}();

exports["default"] = JSONConverter;

function convertJSON(json, configuration) {
  configuration = new _jsonConfiguration["default"](configuration);
  return convertJSONRecursively(json, '', configuration);
}

function convertJSONRecursively(json, key, configuration) {
  if (Array.isArray(json)) {
    return json.map(function (element, i) {
      return convertJSONRecursively(element, String(i), configuration);
    });
  }

  if (isClassInstance(json, configuration)) {
    return convertClassInstance(json, configuration);
  }

  if (isObject(json)) {
    return convertPlainObject(json, configuration);
  }

  if (typeof json === 'string') {
    return convertString(json, key, configuration);
  }

  return json;
}

function isClassInstance(json, configuration) {
  var typeKey = configuration.typeKey;
  var isClass = isObject(json) && Boolean(json[typeKey]);
  return isClass;
}

function convertClassInstance(json, configuration) {
  var typeKey = configuration.typeKey;
  var type = json[typeKey];

  var props = _objectSpread({}, json);

  delete props[typeKey];
  props = convertPlainObject(props, configuration);
  return (0, _instantiateClass.instantiateClass)(type, props, configuration);
}

function convertPlainObject(json, configuration) {
  (0, _assert["default"])(isObject(json));
  var result = {};

  for (var key in json) {
    var value = json[key];
    result[key] = convertJSONRecursively(value, key, configuration);
  }

  return result;
}

function convertString(string, key, configuration) {
  if (string.startsWith(_syntacticSugar.FUNCTION_IDENTIFIER) && configuration.convertFunction) {
    string = string.replace(_syntacticSugar.FUNCTION_IDENTIFIER, '');
    return configuration.convertFunction(string, configuration);
  }

  if (string.startsWith(_syntacticSugar.CONSTANT_IDENTIFIER)) {
    string = string.replace(_syntacticSugar.CONSTANT_IDENTIFIER, '');

    if (configuration.constants[string]) {
      return configuration.constants[string];
    }

    var _string$split = string.split('.'),
        _string$split2 = (0, _slicedToArray2["default"])(_string$split, 2),
        enumVarName = _string$split2[0],
        enumValName = _string$split2[1];

    return configuration.enumerations[enumVarName][enumValName];
  }

  return string;
}
//# sourceMappingURL=json-converter.js.map