"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var state = {
  onIninitialize: function onIninitialize(_) {
    return _;
  },
  onFinalize: function onFinalize(_) {
    return _;
  },
  onMessage: null
};

var Transport = function () {
  (0, _createClass2["default"])(Transport, null, [{
    key: "setCallbacks",
    value: function setCallbacks(_ref) {
      var onInitialize = _ref.onInitialize,
          onFinalize = _ref.onFinalize,
          onMessage = _ref.onMessage;

      if (onInitialize) {
        state.onInitialize = onInitialize;
      }

      if (onFinalize) {
        state.onFinalize = onFinalize;
      }

      if (onMessage) {
        state.onMessage = onMessage;
      }
    }
  }]);

  function Transport() {
    var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'Transport';
    (0, _classCallCheck2["default"])(this, Transport);
    this.name = name;
    this._messageQueue = [];
    this.userData = {};
  }

  (0, _createClass2["default"])(Transport, [{
    key: "sendJSONMessage",
    value: function sendJSONMessage() {
      console.error('Back-channel not implemented for this transport');
    }
  }, {
    key: "sendBinaryMessage",
    value: function sendBinaryMessage() {
      console.error('Back-channel not implemented for this transport');
    }
  }, {
    key: "_initialize",
    value: function _initialize() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var message = _objectSpread({
        transport: this
      }, options);

      state.onInitialize(message);
    }
  }, {
    key: "_finalize",
    value: function _finalize() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var message = _objectSpread({
        transport: this
      }, options);

      state.onFinalize(message);
      this._destroyed = true;
    }
  }, {
    key: "_messageReceived",
    value: function _messageReceived() {
      var message = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      message = _objectSpread({
        transport: this
      }, message);
      console.debug('Delivering transport message', message);
      state.onMessage(message);
    }
  }]);
  return Transport;
}();

exports["default"] = Transport;
//# sourceMappingURL=transport.js.map