import convertFunctions from './convert-functions';
export function instantiateClass(type, props, configuration) {
  const Class = configuration.classes[type];
  const Component = configuration.reactComponents[type];

  if (!Class && !Component) {
    const {
      log
    } = configuration;
    const stringProps = JSON.stringify(props, null, 0).slice(0, 40);

    if (log) {
      log.warn("JSON converter: No registered class of type ".concat(type, "(").concat(stringProps, "...)  "));
    }

    return null;
  }

  if (Class) {
    return instantiateJavaScriptClass(Class, props, configuration);
  }

  return instantiateReactComponent(Component, props, configuration);
}

function instantiateJavaScriptClass(Class, props, configuration) {
  if (configuration.preProcessClassProps) {
    props = configuration.preProcessClassProps(Class, props, configuration);
  }

  props = convertFunctions(props, configuration);
  return new Class(props);
}

function instantiateReactComponent(Component, props, configuration) {
  const {
    React
  } = configuration;
  const {
    children = []
  } = props;
  delete props.children;

  if (configuration.preProcessClassProps) {
    props = configuration.preProcessClassProps(Component, props, configuration);
  }

  props = convertFunctions(props, configuration);
  return React.createElement(Component, props, children);
}
//# sourceMappingURL=instantiate-class.js.map