import { get } from '../utils/get';
import expressionEval from 'expression-eval';
const cachedExpressionMap = {
  '-': object => object
};
export default function parseExpressionString(propValue, configuration) {
  if (propValue in cachedExpressionMap) {
    return cachedExpressionMap[propValue];
  }

  let func;
  const ast = expressionEval.parse(propValue);

  if (!ast.right && !ast.left && ast.type === 'Identifier') {
    func = row => {
      return get(row, propValue);
    };
  } else {
    traverse(ast, node => {
      if (node.type === 'CallExpression') {
        throw new Error('Function calls not allowed in JSON expressions');
      }
    });

    func = row => {
      return expressionEval.eval(ast, row);
    };
  }

  cachedExpressionMap[propValue] = func;
  return func;
}

function traverse(node, visitor) {
  if (Array.isArray(node)) {
    node.forEach(element => traverse(element, visitor));
  } else if (node && typeof node === 'object') {
    if (node.type) {
      visitor(node);
    }

    for (const key in node) {
      traverse(node[key], visitor);
    }
  }
}
//# sourceMappingURL=parse-expression-string.js.map