import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import assert from './utils/assert';
import JSONConfiguration from './json-configuration';
import { instantiateClass } from './helpers/instantiate-class';
import { FUNCTION_IDENTIFIER, CONSTANT_IDENTIFIER } from './syntactic-sugar';
import parseJSON from './helpers/parse-json';

const isObject = value => value && typeof value === 'object';

export default class JSONConverter {
  constructor(props) {
    this.log = console;
    this.configuration = {};

    this.onJSONChange = () => {};

    this.json = null;
    this.convertedJson = null;
    this.setProps(props);
  }

  finalize() {}

  setProps(props) {
    if ('configuration' in props) {
      this.configuration = props.configuration instanceof JSONConfiguration ? props.configuration : new JSONConfiguration(props.configuration);
    }

    if ('onJSONChange' in props) {
      this.onJSONChange = props.onJSONChange;
    }
  }

  mergeConfiguration(config) {
    this.configuration.merge(config);
  }

  convert(json) {
    if (!json || json === this.json) {
      return this.convertedJson;
    }

    this.json = json;
    const parsedJSON = parseJSON(json);
    let convertedJson = convertJSON(parsedJSON, this.configuration);
    convertedJson = this.configuration.postProcessConvertedJson(convertedJson);
    this.convertedJson = convertedJson;
    return convertedJson;
  }

  convertJson(json) {
    return this.convert(json);
  }

}

function convertJSON(json, configuration) {
  configuration = new JSONConfiguration(configuration);
  return convertJSONRecursively(json, '', configuration);
}

function convertJSONRecursively(json, key, configuration) {
  if (Array.isArray(json)) {
    return json.map((element, i) => convertJSONRecursively(element, String(i), configuration));
  }

  if (isClassInstance(json, configuration)) {
    return convertClassInstance(json, configuration);
  }

  if (isObject(json)) {
    return convertPlainObject(json, configuration);
  }

  if (typeof json === 'string') {
    return convertString(json, key, configuration);
  }

  return json;
}

function isClassInstance(json, configuration) {
  const {
    typeKey
  } = configuration;
  const isClass = isObject(json) && Boolean(json[typeKey]);
  return isClass;
}

function convertClassInstance(json, configuration) {
  const {
    typeKey
  } = configuration;
  const type = json[typeKey];

  let props = _objectSpread({}, json);

  delete props[typeKey];
  props = convertPlainObject(props, configuration);
  return instantiateClass(type, props, configuration);
}

function convertPlainObject(json, configuration) {
  assert(isObject(json));
  const result = {};

  for (const key in json) {
    const value = json[key];
    result[key] = convertJSONRecursively(value, key, configuration);
  }

  return result;
}

function convertString(string, key, configuration) {
  if (string.startsWith(FUNCTION_IDENTIFIER) && configuration.convertFunction) {
    string = string.replace(FUNCTION_IDENTIFIER, '');
    return configuration.convertFunction(string, configuration);
  }

  if (string.startsWith(CONSTANT_IDENTIFIER)) {
    string = string.replace(CONSTANT_IDENTIFIER, '');

    if (configuration.constants[string]) {
      return configuration.constants[string];
    }

    const [enumVarName, enumValName] = string.split('.');
    return configuration.enumerations[enumVarName][enumValName];
  }

  return string;
}
//# sourceMappingURL=json-converter.js.map