import parseExpressionString from './helpers/parse-expression-string';
import assert from './utils/assert';
import { TYPE_KEY } from './syntactic-sugar';

const isObject = value => value && typeof value === 'object';

export default class JSONConfiguration {
  constructor(...configurations) {
    this.typeKey = TYPE_KEY;
    this.log = console;
    this.classes = {};
    this.reactComponents = {};
    this.enumerations = {};
    this.constants = {};
    this.convertFunction = convertFunction;

    this.preProcessClassProps = (Class, props) => props;

    this.postProcessConvertedJson = json => json;

    for (const configuration of configurations) {
      this.merge(configuration);
    }
  }

  merge(configuration) {
    for (const key in configuration) {
      switch (key) {
        case 'layers':
        case 'views':
          Object.assign(this.classes, configuration[key]);
          break;

        default:
          if (key in this) {
            const value = configuration[key];
            this[key] = isObject(this[key]) ? Object.assign(this[key], value) : value;
          }

      }
    }
  }

  validate(configuration) {
    assert(!this.typeKey || typeof this.typeKey === 'string');
    assert(isObject(this.classes));
    return true;
  }

}

function convertFunction(value, configuration) {
  return parseExpressionString(value, configuration);
}
//# sourceMappingURL=json-configuration.js.map