import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

const state = {
  onIninitialize: _ => _,
  onFinalize: _ => _,
  onMessage: null
};
export default class Transport {
  static setCallbacks({
    onInitialize,
    onFinalize,
    onMessage
  }) {
    if (onInitialize) {
      state.onInitialize = onInitialize;
    }

    if (onFinalize) {
      state.onFinalize = onFinalize;
    }

    if (onMessage) {
      state.onMessage = onMessage;
    }
  }

  constructor(name = 'Transport') {
    this.name = name;
    this._messageQueue = [];
    this.userData = {};
  }

  sendJSONMessage() {
    console.error('Back-channel not implemented for this transport');
  }

  sendBinaryMessage() {
    console.error('Back-channel not implemented for this transport');
  }

  _initialize(options = {}) {
    const message = _objectSpread({
      transport: this
    }, options);

    state.onInitialize(message);
  }

  _finalize(options = {}) {
    const message = _objectSpread({
      transport: this
    }, options);

    state.onFinalize(message);
    this._destroyed = true;
  }

  _messageReceived(message = {}) {
    message = _objectSpread({
      transport: this
    }, message);
    console.debug('Delivering transport message', message);
    state.onMessage(message);
  }

}
//# sourceMappingURL=transport.js.map