import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { log } from '@deck.gl/core';
import { Geometry, uid } from '@luma.gl/core';
export default class ColumnGeometry extends Geometry {
  constructor(props = {}) {
    const {
      id = uid('column-geometry')
    } = props;
    const {
      indices,
      attributes
    } = tesselateColumn(props);
    super(_objectSpread({}, props, {
      id,
      indices,
      attributes
    }));
  }

}

function tesselateColumn(props) {
  const {
    radius,
    height = 1,
    nradial = 10,
    vertices
  } = props;
  log.assert(!vertices || vertices.length >= nradial);
  const vertsAroundEdge = nradial + 1;
  const numVertices = vertsAroundEdge * 3;
  const stepAngle = Math.PI * 2 / nradial;
  const indices = new Uint16Array(nradial * 3 * 2);
  const positions = new Float32Array(numVertices * 3);
  const normals = new Float32Array(numVertices * 3);
  let i = 0;

  for (let j = 0; j < vertsAroundEdge; j++) {
    const a = j * stepAngle;
    const vertex = vertices && vertices[j % nradial];
    const nextVertex = vertices && vertices[(j + 1) % nradial];
    const sin = Math.sin(a);
    const cos = Math.cos(a);

    for (let k = 0; k < 2; k++) {
      positions[i + 0] = vertex ? vertex[0] : cos * radius;
      positions[i + 1] = vertex ? vertex[1] : sin * radius;
      positions[i + 2] = (1 / 2 - k) * height;
      normals[i + 0] = vertex ? nextVertex[0] - vertex[0] : cos;
      normals[i + 1] = vertex ? nextVertex[1] - vertex[1] : sin;
      i += 3;
    }
  }

  for (let j = 0; j < vertsAroundEdge; j++) {
    const v = Math.floor(j / 2) * Math.sign(j % 2 - 0.5);
    const a = v * stepAngle;
    const vertex = vertices && vertices[(v + nradial) % nradial];
    const sin = Math.sin(a);
    const cos = Math.cos(a);
    positions[i + 0] = vertex ? vertex[0] : cos * radius;
    positions[i + 1] = vertex ? vertex[1] : sin * radius;
    positions[i + 2] = height / 2;
    normals[i + 2] = 1;
    i += 3;
  }

  let index = 0;

  for (let j = 0; j < nradial; j++) {
    indices[index++] = j * 2 + 0;
    indices[index++] = j * 2 + 2;
    indices[index++] = j * 2 + 0;
    indices[index++] = j * 2 + 1;
    indices[index++] = j * 2 + 1;
    indices[index++] = j * 2 + 3;
  }

  return {
    indices,
    attributes: {
      POSITION: {
        size: 3,
        value: positions
      },
      NORMAL: {
        size: 3,
        value: normals
      }
    }
  };
}
//# sourceMappingURL=column-geometry.js.map