import IconLayer from '../../icon-layer/icon-layer';
import fs from './multi-icon-layer-fragment.glsl';
const DEFAULT_GAMMA = 0.2;
const DEFAULT_BUFFER = 192.0 / 256;
const EMPTY_ARRAY = [];
const defaultProps = {
  backgroundColor: {
    type: 'color',
    value: null,
    optional: true
  },
  getIconOffsets: {
    type: 'accessor',
    value: x => x.offsets
  }
};
export default class MultiIconLayer extends IconLayer {
  getShaders() {
    return Object.assign({}, super.getShaders(), {
      inject: {
        'vs:#decl': "\n  uniform float gamma;\n  varying float vGamma;\n",
        'vs:#main-end': "\n  vGamma = gamma / (sizeScale * iconSize.y);\n"
      },
      fs
    });
  }

  initializeState() {
    super.initializeState();
    const attributeManager = this.getAttributeManager();
    attributeManager.addInstanced({
      instanceOffsets: {
        size: 2,
        accessor: 'getIconOffsets'
      },
      instancePickingColors: {
        type: 5121,
        size: 3,
        accessor: (object, {
          index,
          target: value
        }) => this.encodePickingColor(index, value)
      }
    });
  }

  updateState(updateParams) {
    super.updateState(updateParams);
    const {
      oldProps,
      props
    } = updateParams;

    if (props.backgroundColor !== oldProps.backgroundColor) {
      const backgroundColor = Array.isArray(props.backgroundColor) ? props.backgroundColor.map(c => c / 255.0).slice(0, 3) : null;
      this.setState({
        backgroundColor
      });
    }
  }

  draw({
    uniforms
  }) {
    const {
      sdf
    } = this.props;
    const {
      backgroundColor
    } = this.state;
    const shouldDrawBackground = Array.isArray(backgroundColor);
    super.draw({
      uniforms: Object.assign({}, uniforms, {
        buffer: DEFAULT_BUFFER,
        gamma: DEFAULT_GAMMA,
        sdf: Boolean(sdf),
        backgroundColor: backgroundColor || [0, 0, 0],
        shouldDrawBackground
      })
    });
  }

  getInstanceOffset(icons) {
    return icons ? Array.from(icons).map(icon => super.getInstanceOffset(icon)) : EMPTY_ARRAY;
  }

  getInstanceColorMode(icons) {
    return 1;
  }

  getInstanceIconFrame(icons) {
    return icons ? Array.from(icons).map(icon => super.getInstanceIconFrame(icon)) : EMPTY_ARRAY;
  }

}
MultiIconLayer.layerName = 'MultiIconLayer';
MultiIconLayer.defaultProps = defaultProps;
//# sourceMappingURL=multi-icon-layer.js.map