import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import { CompositeLayer, createIterable } from '@deck.gl/core';
import MultiIconLayer from './multi-icon-layer/multi-icon-layer';
import FontAtlasManager, { DEFAULT_CHAR_SET, DEFAULT_FONT_FAMILY, DEFAULT_FONT_WEIGHT, DEFAULT_FONT_SIZE, DEFAULT_BUFFER, DEFAULT_RADIUS, DEFAULT_CUTOFF } from './font-atlas-manager';
import { transformParagraph, getTextFromBuffer } from './utils';
const DEFAULT_FONT_SETTINGS = {
  fontSize: DEFAULT_FONT_SIZE,
  buffer: DEFAULT_BUFFER,
  sdf: false,
  radius: DEFAULT_RADIUS,
  cutoff: DEFAULT_CUTOFF
};
const TEXT_ANCHOR = {
  start: 1,
  middle: 0,
  end: -1
};
const ALIGNMENT_BASELINE = {
  top: 1,
  center: 0,
  bottom: -1
};
const DEFAULT_COLOR = [0, 0, 0, 255];
const DEFAULT_LINE_HEIGHT = 1.0;
const FONT_SETTINGS_PROPS = ['fontSize', 'buffer', 'sdf', 'radius', 'cutoff'];
const defaultProps = {
  billboard: true,
  sizeScale: 1,
  sizeUnits: 'pixels',
  sizeMinPixels: 0,
  sizeMaxPixels: Number.MAX_SAFE_INTEGER,
  backgroundColor: {
    type: 'color',
    value: null,
    optional: true
  },
  characterSet: DEFAULT_CHAR_SET,
  fontFamily: DEFAULT_FONT_FAMILY,
  fontWeight: DEFAULT_FONT_WEIGHT,
  lineHeight: DEFAULT_LINE_HEIGHT,
  fontSettings: {},
  wordBreak: 'word-break',
  maxWidth: {
    type: 'number',
    value: -1
  },
  getText: {
    type: 'accessor',
    value: x => x.text
  },
  getPosition: {
    type: 'accessor',
    value: x => x.position
  },
  getColor: {
    type: 'accessor',
    value: DEFAULT_COLOR
  },
  getSize: {
    type: 'accessor',
    value: 32
  },
  getAngle: {
    type: 'accessor',
    value: 0
  },
  getTextAnchor: {
    type: 'accessor',
    value: 'middle'
  },
  getAlignmentBaseline: {
    type: 'accessor',
    value: 'center'
  },
  getPixelOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};
export default class TextLayer extends CompositeLayer {
  initializeState() {
    this.state = {
      styleVersion: 0,
      fontAtlasManager: new FontAtlasManager(this.context.gl)
    };
  }

  updateState({
    props,
    oldProps,
    changeFlags
  }) {
    const fontChanged = this._fontChanged(oldProps, props);

    if (fontChanged) {
      this._updateFontAtlas(oldProps, props);
    }

    const styleChanged = fontChanged || props.lineHeight !== oldProps.lineHeight || props.wordBreak !== oldProps.wordBreak || props.maxWidth !== oldProps.maxWidth;
    const textChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getText);

    if (textChanged) {
      this._updateText();
    }

    if (styleChanged) {
      this.setState({
        styleVersion: this.state.styleVersion + 1
      });
    }
  }

  finalizeState() {
    super.finalizeState();
    this.state.fontAtlasManager.finalize();
  }

  getPickingInfo({
    info
  }) {
    return Object.assign(info, {
      object: info.index >= 0 ? this.props.data[info.index] : null
    });
  }

  _updateFontAtlas(oldProps, props) {
    const {
      characterSet,
      fontSettings,
      fontFamily,
      fontWeight
    } = props;
    const {
      fontAtlasManager
    } = this.state;
    fontAtlasManager.setProps(Object.assign({}, DEFAULT_FONT_SETTINGS, fontSettings, {
      characterSet,
      fontFamily,
      fontWeight
    }));
    this.setNeedsRedraw(true);
  }

  _fontChanged(oldProps, props) {
    if (oldProps.fontFamily !== props.fontFamily || oldProps.characterSet !== props.characterSet || oldProps.fontWeight !== props.fontWeight) {
      return true;
    }

    if (oldProps.fontSettings === props.fontSettings) {
      return false;
    }

    const oldFontSettings = oldProps.fontSettings || {};
    const fontSettings = props.fontSettings || {};
    return FONT_SETTINGS_PROPS.some(prop => oldFontSettings[prop] !== fontSettings[prop]);
  }

  _updateText() {
    const {
      data
    } = this.props;
    const textBuffer = data.attributes && data.attributes.getText;
    let {
      getText
    } = this.props;
    let {
      startIndices
    } = data;
    let numInstances;

    if (textBuffer && startIndices) {
      const {
        texts,
        characterCount
      } = getTextFromBuffer(_objectSpread({}, ArrayBuffer.isView(textBuffer) ? {
        value: textBuffer
      } : textBuffer, {
        length: data.length,
        startIndices
      }));
      numInstances = characterCount;

      getText = (_, {
        index
      }) => texts[index];
    } else {
      const {
        iterable,
        objectInfo
      } = createIterable(data);
      startIndices = [0];
      numInstances = 0;

      for (const object of iterable) {
        objectInfo.index++;
        const text = getText(object, objectInfo) || '';
        numInstances += text.length;
        startIndices.push(numInstances);
      }
    }

    this.setState({
      getText,
      startIndices,
      numInstances
    });
  }

  getIconOffsets(object, objectInfo) {
    const iconMapping = this.state.fontAtlasManager.mapping;
    const {
      getText
    } = this.state;
    const {
      wordBreak,
      maxWidth,
      lineHeight,
      getTextAnchor,
      getAlignmentBaseline
    } = this.props;
    const paragraph = getText(object, objectInfo) || '';
    const {
      characters,
      size: [width, height]
    } = transformParagraph(paragraph, lineHeight, wordBreak, maxWidth, iconMapping);
    const anchorX = TEXT_ANCHOR[typeof getTextAnchor === 'function' ? getTextAnchor(object, objectInfo) : getTextAnchor];
    const anchorY = ALIGNMENT_BASELINE[typeof getAlignmentBaseline === 'function' ? getAlignmentBaseline(object, objectInfo) : getAlignmentBaseline];
    const offsets = new Array(paragraph.length * 2);
    let index = 0;

    for (const {
      rowWidth,
      x,
      y
    } of characters) {
      const rowOffset = (1 - anchorX) * (width - rowWidth) / 2;
      offsets[index++] = (anchorX - 1) * width / 2 + rowOffset + x;
      offsets[index++] = (anchorY - 1) * height / 2 + y;
    }

    return offsets;
  }

  renderLayers() {
    const {
      startIndices,
      numInstances,
      getText,
      fontAtlasManager: {
        scale,
        texture,
        mapping
      },
      styleVersion
    } = this.state;
    const {
      data,
      _dataDiff,
      backgroundColor,
      getPosition,
      getColor,
      getSize,
      getAngle,
      getPixelOffset,
      billboard,
      sdf,
      sizeScale,
      sizeUnits,
      sizeMinPixels,
      sizeMaxPixels,
      transitions,
      updateTriggers
    } = this.props;
    const getIconOffsets = this.getIconOffsets.bind(this);
    const SubLayerClass = this.getSubLayerClass('characters', MultiIconLayer);
    return new SubLayerClass({
      sdf,
      iconAtlas: texture,
      iconMapping: mapping,
      backgroundColor,
      getPosition,
      getColor,
      getSize,
      getAngle,
      getPixelOffset,
      billboard,
      sizeScale: sizeScale * scale,
      sizeUnits,
      sizeMinPixels: sizeMinPixels * scale,
      sizeMaxPixels: sizeMaxPixels * scale,
      transitions: transitions && {
        getPosition: transitions.getPosition,
        getAngle: transitions.getAngle,
        getColor: transitions.getColor,
        getSize: transitions.getSize,
        getPixelOffset: updateTriggers.getPixelOffset
      }
    }, this.getSubLayerProps({
      id: 'characters',
      updateTriggers: {
        getPosition: updateTriggers.getPosition,
        getAngle: updateTriggers.getAngle,
        getColor: updateTriggers.getColor,
        getSize: updateTriggers.getSize,
        getPixelOffset: updateTriggers.getPixelOffset,
        getIconOffsets: {
          getText: updateTriggers.getText,
          getTextAnchor: updateTriggers.getTextAnchor,
          getAlignmentBaseline: updateTriggers.getAlignmentBaseline,
          styleVersion
        }
      }
    }), {
      data,
      _dataDiff,
      startIndices,
      numInstances,
      getIconOffsets,
      getIcon: getText
    });
  }

}
TextLayer.layerName = 'TextLayer';
TextLayer.defaultProps = defaultProps;
//# sourceMappingURL=text-layer.js.map