import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

var _DEFAULT_TEXTURE_PARA;

import { Layer, project32, picking } from '@deck.gl/core';
import { Model, Geometry, Texture2D } from '@luma.gl/core';
import createMesh from './create-mesh';
import vs from './bitmap-layer-vertex';
import fs from './bitmap-layer-fragment';
var DEFAULT_TEXTURE_PARAMETERS = (_DEFAULT_TEXTURE_PARA = {}, _defineProperty(_DEFAULT_TEXTURE_PARA, 10241, 9987), _defineProperty(_DEFAULT_TEXTURE_PARA, 10240, 9729), _defineProperty(_DEFAULT_TEXTURE_PARA, 10242, 33071), _defineProperty(_DEFAULT_TEXTURE_PARA, 10243, 33071), _DEFAULT_TEXTURE_PARA);
var defaultProps = {
  image: {
    type: 'object',
    value: null,
    async: true
  },
  bounds: {
    type: 'array',
    value: [1, 0, 0, 1],
    compare: true
  },
  desaturate: {
    type: 'number',
    min: 0,
    max: 1,
    value: 0
  },
  transparentColor: {
    type: 'color',
    value: [0, 0, 0, 0]
  },
  tintColor: {
    type: 'color',
    value: [255, 255, 255]
  }
};

var BitmapLayer = function (_Layer) {
  _inherits(BitmapLayer, _Layer);

  function BitmapLayer() {
    _classCallCheck(this, BitmapLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(BitmapLayer).apply(this, arguments));
  }

  _createClass(BitmapLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return _get(_getPrototypeOf(BitmapLayer.prototype), "getShaders", this).call(this, {
        vs: vs,
        fs: fs,
        modules: [project32, picking]
      });
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var _this = this;

      var attributeManager = this.getAttributeManager();
      attributeManager.remove(['instancePickingColors']);
      var noAlloc = true;
      attributeManager.add({
        indices: {
          size: 1,
          isIndexed: true,
          update: function update(attribute) {
            return attribute.value = _this.state.mesh.indices;
          },
          noAlloc: noAlloc
        },
        positions: {
          size: 3,
          type: 5130,
          fp64: this.use64bitPositions(),
          update: function update(attribute) {
            return attribute.value = _this.state.mesh.positions;
          },
          noAlloc: noAlloc
        },
        texCoords: {
          size: 2,
          update: function update(attribute) {
            return attribute.value = _this.state.mesh.texCoords;
          },
          noAlloc: noAlloc
        }
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (changeFlags.extensionsChanged) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model["delete"]();
        }

        this.setState({
          model: this._getModel(gl)
        });
        this.getAttributeManager().invalidateAll();
      }

      if (props.image !== oldProps.image) {
        this.loadTexture(props.image);
      }

      var attributeManager = this.getAttributeManager();

      if (props.bounds !== oldProps.bounds) {
        var oldMesh = this.state.mesh;

        var mesh = this._createMesh();

        this.state.model.setVertexCount(mesh.vertexCount);

        for (var key in mesh) {
          if (oldMesh && oldMesh[key] !== mesh[key]) {
            attributeManager.invalidate(key);
          }
        }

        this.setState({
          mesh: mesh
        });
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      _get(_getPrototypeOf(BitmapLayer.prototype), "finalizeState", this).call(this);

      if (this.state.bitmapTexture) {
        this.state.bitmapTexture["delete"]();
      }
    }
  }, {
    key: "_createMesh",
    value: function _createMesh() {
      var bounds = this.props.bounds;
      var normalizedBounds = bounds;

      if (Number.isFinite(bounds[0])) {
        normalizedBounds = [[bounds[0], bounds[1]], [bounds[0], bounds[3]], [bounds[2], bounds[3]], [bounds[2], bounds[1]]];
      }

      return createMesh(normalizedBounds, this.context.viewport.resolution);
    }
  }, {
    key: "_getModel",
    value: function _getModel(gl) {
      if (!gl) {
        return null;
      }

      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new Geometry({
          drawMode: 4,
          vertexCount: 6
        }),
        isInstanced: false
      }));
    }
  }, {
    key: "draw",
    value: function draw(opts) {
      var uniforms = opts.uniforms;
      var _this$state = this.state,
          bitmapTexture = _this$state.bitmapTexture,
          model = _this$state.model;
      var _this$props = this.props,
          image = _this$props.image,
          desaturate = _this$props.desaturate,
          transparentColor = _this$props.transparentColor,
          tintColor = _this$props.tintColor;

      if (bitmapTexture && image instanceof HTMLVideoElement && image.readyState > HTMLVideoElement.HAVE_METADATA) {
        var sizeChanged = bitmapTexture.width !== image.videoWidth || bitmapTexture.height !== image.videoHeight;

        if (sizeChanged) {
          bitmapTexture.resize({
            width: image.videoWidth,
            height: image.videoHeight,
            mipmaps: true
          });
          bitmapTexture.setSubImageData({
            data: image,
            paramters: DEFAULT_TEXTURE_PARAMETERS
          });
        } else {
          bitmapTexture.setSubImageData({
            data: image
          });
        }

        bitmapTexture.generateMipmap();
      }

      if (bitmapTexture && model) {
        model.setUniforms(Object.assign({}, uniforms, {
          bitmapTexture: bitmapTexture,
          desaturate: desaturate,
          transparentColor: transparentColor.map(function (x) {
            return x / 255;
          }),
          tintColor: tintColor.slice(0, 3).map(function (x) {
            return x / 255;
          })
        })).draw();
      }
    }
  }, {
    key: "loadTexture",
    value: function loadTexture(image) {
      var gl = this.context.gl;

      if (this.state.bitmapTexture) {
        this.state.bitmapTexture["delete"]();
      }

      if (image instanceof Texture2D) {
        this.setState({
          bitmapTexture: image
        });
      } else if (image instanceof HTMLVideoElement) {
        this.setState({
          bitmapTexture: new Texture2D(gl, {
            width: 1,
            height: 1,
            parameters: DEFAULT_TEXTURE_PARAMETERS,
            mipmaps: false
          })
        });
      } else if (image) {
        this.setState({
          bitmapTexture: new Texture2D(gl, {
            data: image,
            parameters: DEFAULT_TEXTURE_PARAMETERS
          })
        });
      }
    }
  }]);

  return BitmapLayer;
}(Layer);

export { BitmapLayer as default };
BitmapLayer.layerName = 'BitmapLayer';
BitmapLayer.defaultProps = defaultProps;
//# sourceMappingURL=bitmap-layer.js.map