export default "#define SHADER_NAME multi-icon-layer-fragment-shader\n\nprecision highp float;\n\nuniform float opacity;\nuniform sampler2D iconsTexture;\nuniform float buffer;\nuniform bool sdf;\nuniform float alphaCutoff;\nuniform bool shouldDrawBackground;\nuniform vec3 backgroundColor;\n\nvarying vec4 vColor;\nvarying vec2 vTextureCoords;\nvarying float vGamma;\nvarying vec2 uv;\n\nvoid main(void) {\n  geometry.uv = uv;\n\n  if (!picking_uActive) {\n    float alpha = texture2D(iconsTexture, vTextureCoords).a;\n    if (sdf) {\n      alpha = smoothstep(buffer - vGamma, buffer + vGamma, alpha);\n    }\n    float a = alpha * vColor.a;\n    \n    if (a < alphaCutoff) {\n      if (shouldDrawBackground) {\n        gl_FragColor = vec4(backgroundColor, vColor.a);\n      } else {\n        discard;\n      }\n    } else {\n      if (shouldDrawBackground) {\n        gl_FragColor = vec4(mix(backgroundColor, vColor.rgb, alpha), vColor.a * opacity);\n      } else {\n        gl_FragColor = vec4(vColor.rgb, a * opacity);\n      }\n      DECKGL_FILTER_COLOR(gl_FragColor, geometry);\n    }\n  } else {\n    DECKGL_FILTER_COLOR(gl_FragColor, geometry);\n  }\n}\n";
//# sourceMappingURL=multi-icon-layer-fragment.glsl.js.map