import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import IconLayer from '../../icon-layer/icon-layer';
import fs from './multi-icon-layer-fragment.glsl';
var DEFAULT_GAMMA = 0.2;
var DEFAULT_BUFFER = 192.0 / 256;
var EMPTY_ARRAY = [];
var defaultProps = {
  backgroundColor: {
    type: 'color',
    value: null,
    optional: true
  },
  getIconOffsets: {
    type: 'accessor',
    value: function value(x) {
      return x.offsets;
    }
  }
};

var MultiIconLayer = function (_IconLayer) {
  _inherits(MultiIconLayer, _IconLayer);

  function MultiIconLayer() {
    _classCallCheck(this, MultiIconLayer);

    return _possibleConstructorReturn(this, _getPrototypeOf(MultiIconLayer).apply(this, arguments));
  }

  _createClass(MultiIconLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return Object.assign({}, _get(_getPrototypeOf(MultiIconLayer.prototype), "getShaders", this).call(this), {
        inject: {
          'vs:#decl': "\n  uniform float gamma;\n  varying float vGamma;\n",
          'vs:#main-end': "\n  vGamma = gamma / (sizeScale * iconSize.y);\n"
        },
        fs: fs
      });
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var _this = this;

      _get(_getPrototypeOf(MultiIconLayer.prototype), "initializeState", this).call(this);

      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instanceOffsets: {
          size: 2,
          accessor: 'getIconOffsets'
        },
        instancePickingColors: {
          type: 5121,
          size: 3,
          accessor: function accessor(object, _ref) {
            var index = _ref.index,
                value = _ref.target;
            return _this.encodePickingColor(index, value);
          }
        }
      });
    }
  }, {
    key: "updateState",
    value: function updateState(updateParams) {
      _get(_getPrototypeOf(MultiIconLayer.prototype), "updateState", this).call(this, updateParams);

      var oldProps = updateParams.oldProps,
          props = updateParams.props;

      if (props.backgroundColor !== oldProps.backgroundColor) {
        var backgroundColor = Array.isArray(props.backgroundColor) ? props.backgroundColor.map(function (c) {
          return c / 255.0;
        }).slice(0, 3) : null;
        this.setState({
          backgroundColor: backgroundColor
        });
      }
    }
  }, {
    key: "draw",
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;
      var sdf = this.props.sdf;
      var backgroundColor = this.state.backgroundColor;
      var shouldDrawBackground = Array.isArray(backgroundColor);

      _get(_getPrototypeOf(MultiIconLayer.prototype), "draw", this).call(this, {
        uniforms: Object.assign({}, uniforms, {
          buffer: DEFAULT_BUFFER,
          gamma: DEFAULT_GAMMA,
          sdf: Boolean(sdf),
          backgroundColor: backgroundColor || [0, 0, 0],
          shouldDrawBackground: shouldDrawBackground
        })
      });
    }
  }, {
    key: "getInstanceOffset",
    value: function getInstanceOffset(icons) {
      var _this2 = this;

      return icons ? Array.from(icons).map(function (icon) {
        return _get(_getPrototypeOf(MultiIconLayer.prototype), "getInstanceOffset", _this2).call(_this2, icon);
      }) : EMPTY_ARRAY;
    }
  }, {
    key: "getInstanceColorMode",
    value: function getInstanceColorMode(icons) {
      return 1;
    }
  }, {
    key: "getInstanceIconFrame",
    value: function getInstanceIconFrame(icons) {
      var _this3 = this;

      return icons ? Array.from(icons).map(function (icon) {
        return _get(_getPrototypeOf(MultiIconLayer.prototype), "getInstanceIconFrame", _this3).call(_this3, icon);
      }) : EMPTY_ARRAY;
    }
  }]);

  return MultiIconLayer;
}(IconLayer);

export { MultiIconLayer as default };
MultiIconLayer.layerName = 'MultiIconLayer';
MultiIconLayer.defaultProps = defaultProps;
//# sourceMappingURL=multi-icon-layer.js.map