"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _iconLayerVertex = _interopRequireDefault(require("./icon-layer-vertex.glsl"));

var _iconLayerFragment = _interopRequireDefault(require("./icon-layer-fragment.glsl"));

var _iconManager = _interopRequireDefault(require("./icon-manager"));

var DEFAULT_COLOR = [0, 0, 0, 255];
var defaultProps = {
  iconAtlas: {
    type: 'object',
    value: null,
    async: true
  },
  iconMapping: {
    type: 'object',
    value: {},
    async: true
  },
  sizeScale: {
    type: 'number',
    value: 1,
    min: 0
  },
  billboard: true,
  sizeUnits: 'pixels',
  sizeMinPixels: {
    type: 'number',
    min: 0,
    value: 0
  },
  sizeMaxPixels: {
    type: 'number',
    min: 0,
    value: Number.MAX_SAFE_INTEGER
  },
  alphaCutoff: {
    type: 'number',
    value: 0.05,
    min: 0,
    max: 1
  },
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  getIcon: {
    type: 'accessor',
    value: function value(x) {
      return x.icon;
    }
  },
  getColor: {
    type: 'accessor',
    value: DEFAULT_COLOR
  },
  getSize: {
    type: 'accessor',
    value: 1
  },
  getAngle: {
    type: 'accessor',
    value: 0
  },
  getPixelOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};

var IconLayer = function (_Layer) {
  (0, _inherits2["default"])(IconLayer, _Layer);

  function IconLayer() {
    (0, _classCallCheck2["default"])(this, IconLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(IconLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(IconLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(IconLayer.prototype), "getShaders", this).call(this, {
        vs: _iconLayerVertex["default"],
        fs: _iconLayerFragment["default"],
        modules: [_core.project32, _core.picking]
      });
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var _this = this;

      this.state = {
        iconManager: new _iconManager["default"](this.context.gl, {
          onUpdate: function onUpdate() {
            return _this._onUpdate();
          }
        })
      };
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          type: 5130,
          fp64: this.use64bitPositions(),
          transition: true,
          accessor: 'getPosition'
        },
        instanceSizes: {
          size: 1,
          transition: true,
          accessor: 'getSize',
          defaultValue: 1
        },
        instanceOffsets: {
          size: 2,
          accessor: 'getIcon',
          transform: this.getInstanceOffset
        },
        instanceIconFrames: {
          size: 4,
          accessor: 'getIcon',
          transform: this.getInstanceIconFrame
        },
        instanceColorModes: {
          size: 1,
          type: 5121,
          accessor: 'getIcon',
          transform: this.getInstanceColorMode
        },
        instanceColors: {
          size: this.props.colorFormat.length,
          type: 5121,
          normalized: true,
          transition: true,
          accessor: 'getColor',
          defaultValue: DEFAULT_COLOR
        },
        instanceAngles: {
          size: 1,
          transition: true,
          accessor: 'getAngle'
        },
        instancePixelOffset: {
          size: 2,
          transition: true,
          accessor: 'getPixelOffset'
        }
      });
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var oldProps = _ref.oldProps,
          props = _ref.props,
          changeFlags = _ref.changeFlags;
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(IconLayer.prototype), "updateState", this).call(this, {
        props: props,
        oldProps: oldProps,
        changeFlags: changeFlags
      });
      var attributeManager = this.getAttributeManager();
      var iconAtlas = props.iconAtlas,
          iconMapping = props.iconMapping,
          data = props.data,
          getIcon = props.getIcon;
      var iconManager = this.state.iconManager;
      iconManager.setProps({
        loadOptions: props.loadOptions
      });
      var iconMappingChanged = false;
      var prePacked = iconAtlas || this.internalState.isAsyncPropLoading('iconAtlas');

      if (prePacked) {
        if (oldProps.iconAtlas !== props.iconAtlas) {
          iconManager.setProps({
            iconAtlas: iconAtlas,
            autoPacking: false
          });
        }

        if (oldProps.iconMapping !== props.iconMapping) {
          iconManager.setProps({
            iconMapping: iconMapping
          });
          iconMappingChanged = true;
        }
      } else {
        iconManager.setProps({
          autoPacking: true
        });
      }

      if (changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getIcon)) {
        iconManager.setProps({
          data: data,
          getIcon: getIcon
        });
        iconMappingChanged = true;
      }

      if (iconMappingChanged) {
        attributeManager.invalidate('instanceOffsets');
        attributeManager.invalidate('instanceIconFrames');
        attributeManager.invalidate('instanceColorModes');
      }

      if (changeFlags.extensionsChanged) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model["delete"]();
        }

        this.setState({
          model: this._getModel(gl)
        });
        attributeManager.invalidateAll();
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(IconLayer.prototype), "finalizeState", this).call(this);
      this.state.iconManager.finalize();
    }
  }, {
    key: "draw",
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;
      var _this$props = this.props,
          sizeScale = _this$props.sizeScale,
          sizeMinPixels = _this$props.sizeMinPixels,
          sizeMaxPixels = _this$props.sizeMaxPixels,
          sizeUnits = _this$props.sizeUnits,
          billboard = _this$props.billboard,
          alphaCutoff = _this$props.alphaCutoff;
      var iconManager = this.state.iconManager;
      var viewport = this.context.viewport;
      var iconsTexture = iconManager.getTexture();

      if (iconsTexture && iconsTexture.loaded) {
        this.state.model.setUniforms(Object.assign({}, uniforms, {
          iconsTexture: iconsTexture,
          iconsTextureDim: [iconsTexture.width, iconsTexture.height],
          sizeScale: sizeScale * (sizeUnits === 'pixels' ? viewport.metersPerPixel : 1),
          sizeMinPixels: sizeMinPixels,
          sizeMaxPixels: sizeMaxPixels,
          billboard: billboard,
          alphaCutoff: alphaCutoff
        })).draw();
      }
    }
  }, {
    key: "_getModel",
    value: function _getModel(gl) {
      var positions = [-1, -1, -1, 1, 1, 1, 1, -1];
      return new _core2.Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new _core2.Geometry({
          drawMode: 6,
          attributes: {
            positions: {
              size: 2,
              value: new Float32Array(positions)
            }
          }
        }),
        isInstanced: true
      }));
    }
  }, {
    key: "_onUpdate",
    value: function _onUpdate() {
      this.setNeedsRedraw();
    }
  }, {
    key: "getInstanceOffset",
    value: function getInstanceOffset(icon) {
      var rect = this.state.iconManager.getIconMapping(icon);
      return [rect.width / 2 - rect.anchorX || 0, rect.height / 2 - rect.anchorY || 0];
    }
  }, {
    key: "getInstanceColorMode",
    value: function getInstanceColorMode(icon) {
      var mapping = this.state.iconManager.getIconMapping(icon);
      return mapping.mask ? 1 : 0;
    }
  }, {
    key: "getInstanceIconFrame",
    value: function getInstanceIconFrame(icon) {
      var rect = this.state.iconManager.getIconMapping(icon);
      return [rect.x || 0, rect.y || 0, rect.width || 0, rect.height || 0];
    }
  }, {
    key: "isLoaded",
    get: function get() {
      return (0, _get2["default"])((0, _getPrototypeOf2["default"])(IconLayer.prototype), "isLoaded", this) && this.state.iconManager.isLoaded;
    }
  }]);
  return IconLayer;
}(_core.Layer);

exports["default"] = IconLayer;
IconLayer.layerName = 'IconLayer';
IconLayer.defaultProps = defaultProps;
//# sourceMappingURL=icon-layer.js.map