"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _path = require("./path");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var START_CAP = 1;
var END_CAP = 2;
var INVALID = 4;

var PathTesselator = function (_Tesselator) {
  (0, _inherits2["default"])(PathTesselator, _Tesselator);

  function PathTesselator(opts) {
    (0, _classCallCheck2["default"])(this, PathTesselator);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(PathTesselator).call(this, _objectSpread({}, opts, {
      attributes: {
        positions: {
          size: 3,
          padding: 18,
          initialize: true,
          type: opts.fp64 ? Float64Array : Float32Array
        },
        segmentTypes: {
          size: 1,
          type: Uint8ClampedArray
        }
      }
    })));
  }

  (0, _createClass2["default"])(PathTesselator, [{
    key: "getGeometryFromBuffer",
    value: function getGeometryFromBuffer(buffer) {
      if (this.normalize) {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(PathTesselator.prototype), "getGeometryFromBuffer", this).call(this, buffer);
      }

      return function () {
        return null;
      };
    }
  }, {
    key: "normalizeGeometry",
    value: function normalizeGeometry(path) {
      if (this.normalize) {
        return (0, _path.normalizePath)(path, this.positionSize, this.opts.resolution, this.opts.wrapLongitude);
      }

      return path;
    }
  }, {
    key: "get",
    value: function get(attributeName) {
      return this.attributes[attributeName];
    }
  }, {
    key: "getGeometrySize",
    value: function getGeometrySize(path) {
      if (Array.isArray(path[0])) {
        var size = 0;
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = path[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var subPath = _step.value;
            size += this.getGeometrySize(subPath);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }

        return size;
      }

      var numPoints = this.getPathLength(path);

      if (numPoints < 2) {
        return 0;
      }

      if (this.isClosed(path)) {
        return numPoints < 3 ? 0 : numPoints + 2;
      }

      return numPoints;
    }
  }, {
    key: "updateGeometryAttributes",
    value: function updateGeometryAttributes(path, context) {
      if (context.geometrySize === 0) {
        return;
      }

      if (path && Array.isArray(path[0])) {
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = path[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var subPath = _step2.value;
            var geometrySize = this.getGeometrySize(subPath);
            context.geometrySize = geometrySize;
            this.updateGeometryAttributes(subPath, context);
            context.vertexStart += geometrySize;
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
              _iterator2["return"]();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }
      } else {
        this._updateSegmentTypes(path, context);

        this._updatePositions(path, context);
      }
    }
  }, {
    key: "_updateSegmentTypes",
    value: function _updateSegmentTypes(path, context) {
      var segmentTypes = this.attributes.segmentTypes;
      var isPathClosed = this.isClosed(path);
      var vertexStart = context.vertexStart,
          geometrySize = context.geometrySize;
      segmentTypes.fill(0, vertexStart, vertexStart + geometrySize);

      if (isPathClosed) {
        segmentTypes[vertexStart] = INVALID;
        segmentTypes[vertexStart + geometrySize - 2] = INVALID;
      } else {
        segmentTypes[vertexStart] += START_CAP;
        segmentTypes[vertexStart + geometrySize - 2] += END_CAP;
      }

      segmentTypes[vertexStart + geometrySize - 1] = INVALID;
    }
  }, {
    key: "_updatePositions",
    value: function _updatePositions(path, context) {
      var positions = this.attributes.positions;

      if (!positions) {
        return;
      }

      var vertexStart = context.vertexStart,
          geometrySize = context.geometrySize;
      var p = new Array(3);

      for (var i = vertexStart, ptIndex = 0; ptIndex < geometrySize; i++, ptIndex++) {
        this.getPointOnPath(path, ptIndex, p);
        positions[i * 3] = p[0];
        positions[i * 3 + 1] = p[1];
        positions[i * 3 + 2] = p[2];
      }
    }
  }, {
    key: "getPathLength",
    value: function getPathLength(path) {
      return path.length / this.positionSize;
    }
  }, {
    key: "getPointOnPath",
    value: function getPointOnPath(path, index) {
      var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var positionSize = this.positionSize;

      if (index * positionSize >= path.length) {
        index += 1 - path.length / positionSize;
      }

      var i = index * positionSize;
      target[0] = path[i];
      target[1] = path[i + 1];
      target[2] = positionSize === 3 && path[i + 2] || 0;
      return target;
    }
  }, {
    key: "isClosed",
    value: function isClosed(path) {
      if (!this.normalize) {
        return this.opts.loop;
      }

      var positionSize = this.positionSize;
      var lastPointIndex = path.length - positionSize;
      return path[0] === path[lastPointIndex] && path[1] === path[lastPointIndex + 1] && (positionSize === 2 || path[2] === path[lastPointIndex + 2]);
    }
  }]);
  return PathTesselator;
}(_core.Tesselator);

exports["default"] = PathTesselator;
//# sourceMappingURL=path-tesselator.js.map