"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _iconLayer = _interopRequireDefault(require("../../icon-layer/icon-layer"));

var _multiIconLayerFragment = _interopRequireDefault(require("./multi-icon-layer-fragment.glsl"));

var DEFAULT_GAMMA = 0.2;
var DEFAULT_BUFFER = 192.0 / 256;
var EMPTY_ARRAY = [];
var defaultProps = {
  backgroundColor: {
    type: 'color',
    value: null,
    optional: true
  },
  getIconOffsets: {
    type: 'accessor',
    value: function value(x) {
      return x.offsets;
    }
  }
};

var MultiIconLayer = function (_IconLayer) {
  (0, _inherits2["default"])(MultiIconLayer, _IconLayer);

  function MultiIconLayer() {
    (0, _classCallCheck2["default"])(this, MultiIconLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(MultiIconLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(MultiIconLayer, [{
    key: "getShaders",
    value: function getShaders() {
      return Object.assign({}, (0, _get2["default"])((0, _getPrototypeOf2["default"])(MultiIconLayer.prototype), "getShaders", this).call(this), {
        inject: {
          'vs:#decl': "\n  uniform float gamma;\n  varying float vGamma;\n",
          'vs:#main-end': "\n  vGamma = gamma / (sizeScale * iconSize.y);\n"
        },
        fs: _multiIconLayerFragment["default"]
      });
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var _this = this;

      (0, _get2["default"])((0, _getPrototypeOf2["default"])(MultiIconLayer.prototype), "initializeState", this).call(this);
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instanceOffsets: {
          size: 2,
          accessor: 'getIconOffsets'
        },
        instancePickingColors: {
          type: 5121,
          size: 3,
          accessor: function accessor(object, _ref) {
            var index = _ref.index,
                value = _ref.target;
            return _this.encodePickingColor(index, value);
          }
        }
      });
    }
  }, {
    key: "updateState",
    value: function updateState(updateParams) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(MultiIconLayer.prototype), "updateState", this).call(this, updateParams);
      var oldProps = updateParams.oldProps,
          props = updateParams.props;

      if (props.backgroundColor !== oldProps.backgroundColor) {
        var backgroundColor = Array.isArray(props.backgroundColor) ? props.backgroundColor.map(function (c) {
          return c / 255.0;
        }).slice(0, 3) : null;
        this.setState({
          backgroundColor: backgroundColor
        });
      }
    }
  }, {
    key: "draw",
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;
      var sdf = this.props.sdf;
      var backgroundColor = this.state.backgroundColor;
      var shouldDrawBackground = Array.isArray(backgroundColor);
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(MultiIconLayer.prototype), "draw", this).call(this, {
        uniforms: Object.assign({}, uniforms, {
          buffer: DEFAULT_BUFFER,
          gamma: DEFAULT_GAMMA,
          sdf: Boolean(sdf),
          backgroundColor: backgroundColor || [0, 0, 0],
          shouldDrawBackground: shouldDrawBackground
        })
      });
    }
  }, {
    key: "getInstanceOffset",
    value: function getInstanceOffset(icons) {
      var _this2 = this;

      return icons ? Array.from(icons).map(function (icon) {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(MultiIconLayer.prototype), "getInstanceOffset", _this2).call(_this2, icon);
      }) : EMPTY_ARRAY;
    }
  }, {
    key: "getInstanceColorMode",
    value: function getInstanceColorMode(icons) {
      return 1;
    }
  }, {
    key: "getInstanceIconFrame",
    value: function getInstanceIconFrame(icons) {
      var _this3 = this;

      return icons ? Array.from(icons).map(function (icon) {
        return (0, _get2["default"])((0, _getPrototypeOf2["default"])(MultiIconLayer.prototype), "getInstanceIconFrame", _this3).call(_this3, icon);
      }) : EMPTY_ARRAY;
    }
  }]);
  return MultiIconLayer;
}(_iconLayer["default"]);

exports["default"] = MultiIconLayer;
MultiIconLayer.layerName = 'MultiIconLayer';
MultiIconLayer.defaultProps = defaultProps;
//# sourceMappingURL=multi-icon-layer.js.map