"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _core = require("@deck.gl/core");

var _multiIconLayer = _interopRequireDefault(require("./multi-icon-layer/multi-icon-layer"));

var _fontAtlasManager = _interopRequireWildcard(require("./font-atlas-manager"));

var _utils = require("./utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var DEFAULT_FONT_SETTINGS = {
  fontSize: _fontAtlasManager.DEFAULT_FONT_SIZE,
  buffer: _fontAtlasManager.DEFAULT_BUFFER,
  sdf: false,
  radius: _fontAtlasManager.DEFAULT_RADIUS,
  cutoff: _fontAtlasManager.DEFAULT_CUTOFF
};
var TEXT_ANCHOR = {
  start: 1,
  middle: 0,
  end: -1
};
var ALIGNMENT_BASELINE = {
  top: 1,
  center: 0,
  bottom: -1
};
var DEFAULT_COLOR = [0, 0, 0, 255];
var DEFAULT_LINE_HEIGHT = 1.0;
var FONT_SETTINGS_PROPS = ['fontSize', 'buffer', 'sdf', 'radius', 'cutoff'];
var defaultProps = {
  billboard: true,
  sizeScale: 1,
  sizeUnits: 'pixels',
  sizeMinPixels: 0,
  sizeMaxPixels: Number.MAX_SAFE_INTEGER,
  backgroundColor: {
    type: 'color',
    value: null,
    optional: true
  },
  characterSet: _fontAtlasManager.DEFAULT_CHAR_SET,
  fontFamily: _fontAtlasManager.DEFAULT_FONT_FAMILY,
  fontWeight: _fontAtlasManager.DEFAULT_FONT_WEIGHT,
  lineHeight: DEFAULT_LINE_HEIGHT,
  fontSettings: {},
  wordBreak: 'word-break',
  maxWidth: {
    type: 'number',
    value: -1
  },
  getText: {
    type: 'accessor',
    value: function value(x) {
      return x.text;
    }
  },
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  getColor: {
    type: 'accessor',
    value: DEFAULT_COLOR
  },
  getSize: {
    type: 'accessor',
    value: 32
  },
  getAngle: {
    type: 'accessor',
    value: 0
  },
  getTextAnchor: {
    type: 'accessor',
    value: 'middle'
  },
  getAlignmentBaseline: {
    type: 'accessor',
    value: 'center'
  },
  getPixelOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};

var TextLayer = function (_CompositeLayer) {
  (0, _inherits2["default"])(TextLayer, _CompositeLayer);

  function TextLayer() {
    (0, _classCallCheck2["default"])(this, TextLayer);
    return (0, _possibleConstructorReturn2["default"])(this, (0, _getPrototypeOf2["default"])(TextLayer).apply(this, arguments));
  }

  (0, _createClass2["default"])(TextLayer, [{
    key: "initializeState",
    value: function initializeState() {
      this.state = {
        styleVersion: 0,
        fontAtlasManager: new _fontAtlasManager["default"](this.context.gl)
      };
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      var fontChanged = this._fontChanged(oldProps, props);

      if (fontChanged) {
        this._updateFontAtlas(oldProps, props);
      }

      var styleChanged = fontChanged || props.lineHeight !== oldProps.lineHeight || props.wordBreak !== oldProps.wordBreak || props.maxWidth !== oldProps.maxWidth;
      var textChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getText);

      if (textChanged) {
        this._updateText();
      }

      if (styleChanged) {
        this.setState({
          styleVersion: this.state.styleVersion + 1
        });
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState() {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(TextLayer.prototype), "finalizeState", this).call(this);
      this.state.fontAtlasManager.finalize();
    }
  }, {
    key: "getPickingInfo",
    value: function getPickingInfo(_ref2) {
      var info = _ref2.info;
      return Object.assign(info, {
        object: info.index >= 0 ? this.props.data[info.index] : null
      });
    }
  }, {
    key: "_updateFontAtlas",
    value: function _updateFontAtlas(oldProps, props) {
      var characterSet = props.characterSet,
          fontSettings = props.fontSettings,
          fontFamily = props.fontFamily,
          fontWeight = props.fontWeight;
      var fontAtlasManager = this.state.fontAtlasManager;
      fontAtlasManager.setProps(Object.assign({}, DEFAULT_FONT_SETTINGS, fontSettings, {
        characterSet: characterSet,
        fontFamily: fontFamily,
        fontWeight: fontWeight
      }));
      this.setNeedsRedraw(true);
    }
  }, {
    key: "_fontChanged",
    value: function _fontChanged(oldProps, props) {
      if (oldProps.fontFamily !== props.fontFamily || oldProps.characterSet !== props.characterSet || oldProps.fontWeight !== props.fontWeight) {
        return true;
      }

      if (oldProps.fontSettings === props.fontSettings) {
        return false;
      }

      var oldFontSettings = oldProps.fontSettings || {};
      var fontSettings = props.fontSettings || {};
      return FONT_SETTINGS_PROPS.some(function (prop) {
        return oldFontSettings[prop] !== fontSettings[prop];
      });
    }
  }, {
    key: "_updateText",
    value: function _updateText() {
      var data = this.props.data;
      var textBuffer = data.attributes && data.attributes.getText;
      var getText = this.props.getText;
      var startIndices = data.startIndices;
      var numInstances;

      if (textBuffer && startIndices) {
        var _getTextFromBuffer = (0, _utils.getTextFromBuffer)(_objectSpread({}, ArrayBuffer.isView(textBuffer) ? {
          value: textBuffer
        } : textBuffer, {
          length: data.length,
          startIndices: startIndices
        })),
            texts = _getTextFromBuffer.texts,
            characterCount = _getTextFromBuffer.characterCount;

        numInstances = characterCount;

        getText = function getText(_, _ref3) {
          var index = _ref3.index;
          return texts[index];
        };
      } else {
        var _createIterable = (0, _core.createIterable)(data),
            iterable = _createIterable.iterable,
            objectInfo = _createIterable.objectInfo;

        startIndices = [0];
        numInstances = 0;
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = iterable[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var object = _step.value;
            objectInfo.index++;
            var text = getText(object, objectInfo) || '';
            numInstances += text.length;
            startIndices.push(numInstances);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator["return"] != null) {
              _iterator["return"]();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }

      this.setState({
        getText: getText,
        startIndices: startIndices,
        numInstances: numInstances
      });
    }
  }, {
    key: "getIconOffsets",
    value: function getIconOffsets(object, objectInfo) {
      var iconMapping = this.state.fontAtlasManager.mapping;
      var getText = this.state.getText;
      var _this$props = this.props,
          wordBreak = _this$props.wordBreak,
          maxWidth = _this$props.maxWidth,
          lineHeight = _this$props.lineHeight,
          getTextAnchor = _this$props.getTextAnchor,
          getAlignmentBaseline = _this$props.getAlignmentBaseline;
      var paragraph = getText(object, objectInfo) || '';

      var _transformParagraph = (0, _utils.transformParagraph)(paragraph, lineHeight, wordBreak, maxWidth, iconMapping),
          characters = _transformParagraph.characters,
          _transformParagraph$s = (0, _slicedToArray2["default"])(_transformParagraph.size, 2),
          width = _transformParagraph$s[0],
          height = _transformParagraph$s[1];

      var anchorX = TEXT_ANCHOR[typeof getTextAnchor === 'function' ? getTextAnchor(object, objectInfo) : getTextAnchor];
      var anchorY = ALIGNMENT_BASELINE[typeof getAlignmentBaseline === 'function' ? getAlignmentBaseline(object, objectInfo) : getAlignmentBaseline];
      var offsets = new Array(paragraph.length * 2);
      var index = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = characters[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var _step2$value = _step2.value,
              rowWidth = _step2$value.rowWidth,
              x = _step2$value.x,
              y = _step2$value.y;
          var rowOffset = (1 - anchorX) * (width - rowWidth) / 2;
          offsets[index++] = (anchorX - 1) * width / 2 + rowOffset + x;
          offsets[index++] = (anchorY - 1) * height / 2 + y;
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      return offsets;
    }
  }, {
    key: "renderLayers",
    value: function renderLayers() {
      var _this$state = this.state,
          startIndices = _this$state.startIndices,
          numInstances = _this$state.numInstances,
          getText = _this$state.getText,
          _this$state$fontAtlas = _this$state.fontAtlasManager,
          scale = _this$state$fontAtlas.scale,
          texture = _this$state$fontAtlas.texture,
          mapping = _this$state$fontAtlas.mapping,
          styleVersion = _this$state.styleVersion;
      var _this$props2 = this.props,
          data = _this$props2.data,
          _dataDiff = _this$props2._dataDiff,
          backgroundColor = _this$props2.backgroundColor,
          getPosition = _this$props2.getPosition,
          getColor = _this$props2.getColor,
          getSize = _this$props2.getSize,
          getAngle = _this$props2.getAngle,
          getPixelOffset = _this$props2.getPixelOffset,
          billboard = _this$props2.billboard,
          sdf = _this$props2.sdf,
          sizeScale = _this$props2.sizeScale,
          sizeUnits = _this$props2.sizeUnits,
          sizeMinPixels = _this$props2.sizeMinPixels,
          sizeMaxPixels = _this$props2.sizeMaxPixels,
          transitions = _this$props2.transitions,
          updateTriggers = _this$props2.updateTriggers;
      var getIconOffsets = this.getIconOffsets.bind(this);
      var SubLayerClass = this.getSubLayerClass('characters', _multiIconLayer["default"]);
      return new SubLayerClass({
        sdf: sdf,
        iconAtlas: texture,
        iconMapping: mapping,
        backgroundColor: backgroundColor,
        getPosition: getPosition,
        getColor: getColor,
        getSize: getSize,
        getAngle: getAngle,
        getPixelOffset: getPixelOffset,
        billboard: billboard,
        sizeScale: sizeScale * scale,
        sizeUnits: sizeUnits,
        sizeMinPixels: sizeMinPixels * scale,
        sizeMaxPixels: sizeMaxPixels * scale,
        transitions: transitions && {
          getPosition: transitions.getPosition,
          getAngle: transitions.getAngle,
          getColor: transitions.getColor,
          getSize: transitions.getSize,
          getPixelOffset: updateTriggers.getPixelOffset
        }
      }, this.getSubLayerProps({
        id: 'characters',
        updateTriggers: {
          getPosition: updateTriggers.getPosition,
          getAngle: updateTriggers.getAngle,
          getColor: updateTriggers.getColor,
          getSize: updateTriggers.getSize,
          getPixelOffset: updateTriggers.getPixelOffset,
          getIconOffsets: {
            getText: updateTriggers.getText,
            getTextAnchor: updateTriggers.getTextAnchor,
            getAlignmentBaseline: updateTriggers.getAlignmentBaseline,
            styleVersion: styleVersion
          }
        }
      }), {
        data: data,
        _dataDiff: _dataDiff,
        startIndices: startIndices,
        numInstances: numInstances,
        getIconOffsets: getIconOffsets,
        getIcon: getText
      });
    }
  }]);
  return TextLayer;
}(_core.CompositeLayer);

exports["default"] = TextLayer;
TextLayer.layerName = 'TextLayer';
TextLayer.defaultProps = defaultProps;
//# sourceMappingURL=text-layer.js.map