import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import * as Polygon from './polygon';
import { Tesselator } from '@deck.gl/core';
import { cutPolygonByGrid, cutPolygonByMercatorBounds } from '@math.gl/polygon';
export default class PolygonTesselator extends Tesselator {
  constructor(opts) {
    const {
      fp64,
      IndexType = Uint32Array
    } = opts;
    super(_objectSpread({}, opts, {
      attributes: {
        positions: {
          size: 3,
          type: fp64 ? Float64Array : Float32Array
        },
        vertexValid: {
          type: Uint8ClampedArray,
          size: 1
        },
        indices: {
          type: IndexType,
          size: 1
        }
      }
    }));
  }

  get(attributeName) {
    const {
      attributes
    } = this;

    if (attributeName === 'indices') {
      return attributes.indices && attributes.indices.subarray(0, this.vertexCount);
    }

    return attributes[attributeName];
  }

  updateGeometry(opts) {
    super.updateGeometry(opts);
    const externalIndices = this.buffers.indices;

    if (externalIndices) {
      this.vertexCount = (externalIndices.value || externalIndices).length;
    }
  }

  normalizeGeometry(polygon) {
    if (this.normalize) {
      polygon = Polygon.normalize(polygon, this.positionSize);

      if (this.opts.resolution) {
        return cutPolygonByGrid(polygon.positions || polygon, polygon.holeIndices, {
          size: this.positionSize,
          gridResolution: this.opts.resolution,
          edgeTypes: true
        });
      }

      if (this.opts.wrapLongitude) {
        return cutPolygonByMercatorBounds(polygon.positions || polygon, polygon.holeIndices, {
          size: this.positionSize,
          maxLatitude: 86,
          edgeTypes: true
        });
      }
    }

    return polygon;
  }

  getGeometrySize(polygon) {
    if (Array.isArray(polygon) && !Number.isFinite(polygon[0])) {
      let size = 0;

      for (const subPolygon of polygon) {
        size += this.getGeometrySize(subPolygon);
      }

      return size;
    }

    return (polygon.positions || polygon).length / this.positionSize;
  }

  getGeometryFromBuffer(buffer) {
    if (this.normalize || !this.buffers.indices) {
      return super.getGeometryFromBuffer(buffer);
    }

    return () => null;
  }

  updateGeometryAttributes(polygon, context) {
    if (Array.isArray(polygon) && !Number.isFinite(polygon[0])) {
      for (const subPolygon of polygon) {
        const geometrySize = this.getGeometrySize(subPolygon);
        context.geometrySize = geometrySize;
        this.updateGeometryAttributes(subPolygon, context);
        context.vertexStart += geometrySize;
        context.indexStart = this.indexStarts[context.geometryIndex + 1];
      }
    } else {
      this._updateIndices(polygon, context);

      this._updatePositions(polygon, context);

      this._updateVertexValid(polygon, context);
    }
  }

  _updateIndices(polygon, {
    geometryIndex,
    vertexStart: offset,
    indexStart
  }) {
    const {
      attributes,
      indexStarts,
      typedArrayManager
    } = this;
    let target = attributes.indices;

    if (!target) {
      return;
    }

    let i = indexStart;
    const indices = Polygon.getSurfaceIndices(polygon, this.positionSize, this.opts.preproject);
    target = typedArrayManager.allocate(target, indexStart + indices.length, {
      copy: true
    });

    for (let j = 0; j < indices.length; j++) {
      target[i++] = indices[j] + offset;
    }

    indexStarts[geometryIndex + 1] = indexStart + indices.length;
    attributes.indices = target;
  }

  _updatePositions(polygon, {
    vertexStart,
    geometrySize
  }) {
    const {
      attributes: {
        positions
      },
      positionSize
    } = this;

    if (!positions) {
      return;
    }

    const polygonPositions = polygon.positions || polygon;

    for (let i = vertexStart, j = 0; j < geometrySize; i++, j++) {
      const x = polygonPositions[j * positionSize];
      const y = polygonPositions[j * positionSize + 1];
      const z = positionSize > 2 ? polygonPositions[j * positionSize + 2] : 0;
      positions[i * 3] = x;
      positions[i * 3 + 1] = y;
      positions[i * 3 + 2] = z;
    }
  }

  _updateVertexValid(polygon, {
    vertexStart,
    geometrySize
  }) {
    const {
      attributes: {
        vertexValid
      },
      positionSize
    } = this;
    const holeIndices = polygon && polygon.holeIndices;

    if (polygon && polygon.edgeTypes) {
      vertexValid.set(polygon.edgeTypes, vertexStart);
    } else {
      vertexValid.fill(1, vertexStart, vertexStart + geometrySize);
    }

    if (holeIndices) {
      for (let j = 0; j < holeIndices.length; j++) {
        vertexValid[vertexStart + holeIndices[j] / positionSize - 1] = 0;
      }
    }

    vertexValid[vertexStart + geometrySize - 1] = 0;
  }

}
//# sourceMappingURL=polygon-tesselator.js.map