"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _default = "#version 300 es\nin vec3 instancePositions;\nin vec3 instancePositions64Low;\nin vec4 instanceColors;\nin vec3 instancePickingColors;\nin mat3 instanceModelMatrix;\nin vec3 instanceTranslation;\nuniform float sizeScale;\nuniform float sizeMinPixels;\nuniform float sizeMaxPixels;\nuniform mat4 sceneModelMatrix;\nuniform bool composeModelMatrix;\nin vec4 POSITION;\n\n#ifdef HAS_UV\n  in vec2 TEXCOORD_0;\n#endif\n\n#ifdef MODULE_PBR\n  #ifdef HAS_NORMALS\n    in vec4 NORMAL;\n  #endif\n#endif\nout vec4 vColor;\n#ifndef MODULE_PBR\n  #ifdef HAS_UV\n    out vec2 vTEXCOORD_0;\n  #endif\n#endif\nvoid main(void) {\n  #if defined(HAS_UV) && !defined(MODULE_PBR)\n    vTEXCOORD_0 = TEXCOORD_0;\n    geometry.uv = vTEXCOORD_0;\n  #endif\n\n  geometry.worldPosition = instancePositions;\n  geometry.pickingColor = instancePickingColors;\n\n  #ifdef MODULE_PBR\n    #ifdef HAS_NORMALS\n      pbr_vNormal = project_normal(instanceModelMatrix * (sceneModelMatrix * vec4(NORMAL.xyz, 0.0)).xyz);\n      geometry.normal = pbr_vNormal;\n    #endif\n\n    #ifdef HAS_UV\n      pbr_vUV = TEXCOORD_0;\n    #else\n      pbr_vUV = vec2(0., 0.);\n    #endif\n    geometry.uv = pbr_vUV;\n  #endif\n\n  float originalSize = project_size_to_pixel(sizeScale);\n  float clampedSize = clamp(originalSize, sizeMinPixels, sizeMaxPixels);\n\n  vec3 pos = (instanceModelMatrix * (sceneModelMatrix * POSITION).xyz) * sizeScale * (clampedSize / originalSize) + instanceTranslation;\n  if(composeModelMatrix) {\n    DECKGL_FILTER_SIZE(pos, geometry);\n    gl_Position = project_position_to_clipspace(pos + instancePositions, instancePositions64Low, vec3(0.0), geometry.position);\n  }\n  else {\n    pos = project_size(pos);\n    DECKGL_FILTER_SIZE(pos, geometry);\n    gl_Position = project_position_to_clipspace(instancePositions, instancePositions64Low, pos, geometry.position);\n  }\n  DECKGL_FILTER_GL_POSITION(gl_Position, geometry);\n\n  #ifdef MODULE_PBR\n    pbr_vPosition = geometry.position.xyz;\n  #endif\n\n  vColor = instanceColors;\n  DECKGL_FILTER_COLOR(vColor, geometry);\n}\n";
exports["default"] = _default;
//# sourceMappingURL=scenegraph-layer-vertex.glsl.js.map