export default "#version 300 es\n#define SHADER_NAME simple-mesh-layer-vs\nuniform float sizeScale;\nuniform bool composeModelMatrix;\nin vec3 positions;\nin vec3 normals;\nin vec2 texCoords;\nin vec3 instancePositions;\nin vec3 instancePositions64Low;\nin vec4 instanceColors;\nin vec3 instancePickingColors;\nin mat3 instanceModelMatrix;\nin vec3 instanceTranslation;\nout vec2 vTexCoord;\nout vec3 cameraPosition;\nout vec3 normals_commonspace;\nout vec4 position_commonspace;\nout vec4 vColor;\n\nvoid main(void) {\n  geometry.worldPosition = instancePositions;\n  geometry.uv = texCoords;\n  geometry.pickingColor = instancePickingColors;\n\n  vTexCoord = texCoords;\n  cameraPosition = project_uCameraPosition;\n  normals_commonspace = project_normal(instanceModelMatrix * normals);\n  vColor = instanceColors;\n  geometry.normal = normals_commonspace;\n\n  vec3 pos = (instanceModelMatrix * positions) * sizeScale + instanceTranslation;\n\n  if (composeModelMatrix) {\n    DECKGL_FILTER_SIZE(pos, geometry);\n    gl_Position = project_position_to_clipspace(pos + instancePositions, instancePositions64Low, vec3(0.0), position_commonspace);\n  }\n  else {\n    pos = project_size(pos);\n    DECKGL_FILTER_SIZE(pos, geometry);\n    gl_Position = project_position_to_clipspace(instancePositions, instancePositions64Low, pos, position_commonspace);\n  }\n\n  geometry.position = position_commonspace;\n  DECKGL_FILTER_GL_POSITION(gl_Position, geometry);\n\n  DECKGL_FILTER_COLOR(vColor, geometry);\n}\n";
//# sourceMappingURL=simple-mesh-layer-vertex.glsl.js.map