"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = evaluateChildren;

var _react = require("react");

var MAP_STYLE = {
  position: 'absolute',
  zIndex: -1
};

function evaluateChildren(children, childProps) {
  if (!children) {
    return children;
  }

  if (typeof children === 'function') {
    return children(childProps);
  }

  if (Array.isArray(children)) {
    return children.map(function (child) {
      return evaluateChildren(child, childProps);
    });
  }

  if (isReactMap(children)) {
    childProps.style = MAP_STYLE;
    return (0, _react.cloneElement)(children, childProps);
  }

  if (needsDeckGLViewProps(children)) {
    return (0, _react.cloneElement)(children, childProps);
  }

  return children;
}

function isReactMap(child) {
  var componentClass = child && child.type;
  var componentProps = componentClass && componentClass.defaultProps;
  return componentProps && componentProps.mapStyle;
}

function needsDeckGLViewProps(child) {
  var componentClass = child && child.type;
  return componentClass && componentClass.deckGLViewProps;
}
//# sourceMappingURL=evaluate-children.js.map