"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = positionChildrenUnderViews;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _react = require("react");

var _core = require("@deck.gl/core");

var _inheritsFrom = require("./inherits-from");

var _evaluateChildren = _interopRequireDefault(require("./evaluate-children"));

function positionChildrenUnderViews(_ref) {
  var children = _ref.children,
      viewports = _ref.viewports,
      deck = _ref.deck,
      ContextProvider = _ref.ContextProvider;

  var _ref2 = deck || {},
      viewManager = _ref2.viewManager;

  if (!viewManager || !viewManager.views.length) {
    return [];
  }

  var views = {};
  var defaultViewId = viewManager.views[0].id;
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = children[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var child = _step.value;
      var viewId = defaultViewId;
      var viewChildren = child;

      if ((0, _inheritsFrom.inheritsFrom)(child.type, _core.View)) {
        viewId = child.props.id || defaultViewId;
        viewChildren = child.props.children;
      }

      var viewport = viewManager.getViewport(viewId);
      var viewState = viewManager.getViewState(viewId);

      if (viewport) {
        var x = viewport.x,
            y = viewport.y,
            width = viewport.width,
            height = viewport.height;
        viewChildren = (0, _evaluateChildren["default"])(viewChildren, {
          x: x,
          y: y,
          width: width,
          height: height,
          viewport: viewport,
          viewState: viewState
        });

        if (!views[viewId]) {
          views[viewId] = {
            viewport: viewport,
            children: []
          };
        }

        views[viewId].children.push(viewChildren);
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return Object.keys(views).map(function (viewId) {
    var _views$viewId = views[viewId],
        viewport = _views$viewId.viewport,
        viewChildren = _views$viewId.children;
    var x = viewport.x,
        y = viewport.y,
        width = viewport.width,
        height = viewport.height;
    var style = {
      position: 'absolute',
      left: x,
      top: y,
      width: width,
      height: height
    };
    var key = "view-".concat(viewId);

    var viewElement = _react.createElement.apply(void 0, ['div', {
      key: key,
      id: key,
      style: style
    }].concat((0, _toConsumableArray2["default"])(viewChildren)));

    if (ContextProvider) {
      var contextValue = {
        viewport: viewport,
        container: deck.canvas.offsetParent,
        eventManager: deck.eventManager,
        onViewStateChange: function onViewStateChange(params) {
          params.viewId = viewId;

          deck._onViewStateChange(params);
        }
      };
      return (0, _react.createElement)(ContextProvider, {
        key: key,
        value: contextValue
      }, viewElement);
    }

    return viewElement;
  });
}
//# sourceMappingURL=position-children-under-views.js.map