var CANVAS_ONLY_STYLES = {
  mixBlendMode: null
};
export default function extractStyles(_ref) {
  var width = _ref.width,
      height = _ref.height,
      style = _ref.style;
  var containerStyle = {
    position: 'absolute',
    zIndex: 0,
    left: 0,
    top: 0,
    width: width,
    height: height
  };
  var canvasStyle = {
    left: 0,
    top: 0
  };

  if (style) {
    for (var key in style) {
      if (key in CANVAS_ONLY_STYLES) {
        canvasStyle[key] = style[key];
      } else {
        containerStyle[key] = style[key];
      }
    }
  }

  return {
    containerStyle: containerStyle,
    canvasStyle: canvasStyle
  };
}
//# sourceMappingURL=extract-styles.js.map