function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from 'react';
import { MAX_QUERY_SIZE } from './constants';
import { LoadingIcon } from './icons/LoadingIcon';
import { ResetIcon } from './icons/ResetIcon';
import { SearchIcon } from './icons/SearchIcon';
export function SearchBox(props) {
  var _props$getFormProps = props.getFormProps({
    inputElement: props.inputRef.current
  }),
      onReset = _props$getFormProps.onReset;

  React.useEffect(function () {
    if (props.autoFocus && props.inputRef.current) {
      props.inputRef.current.focus();
    }
  }, [props.autoFocus, props.inputRef]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("form", {
    action: "",
    role: "search",
    noValidate: true,
    className: "DocSearch-Form",
    onSubmit: function onSubmit(event) {
      event.preventDefault();
    },
    onReset: onReset
  }, /*#__PURE__*/React.createElement("label", _extends({
    className: "DocSearch-MagnifierLabel"
  }, props.getLabelProps()), /*#__PURE__*/React.createElement(SearchIcon, null)), /*#__PURE__*/React.createElement("div", {
    className: "DocSearch-LoadingIndicator"
  }, /*#__PURE__*/React.createElement(LoadingIcon, null)), /*#__PURE__*/React.createElement("input", _extends({
    className: "DocSearch-Input",
    ref: props.inputRef
  }, props.getInputProps({
    inputElement: props.inputRef.current,
    autoFocus: props.autoFocus,
    maxLength: MAX_QUERY_SIZE,
    enterkeyhint: 'go'
  }))), /*#__PURE__*/React.createElement("button", {
    type: "reset",
    title: "Clear the query",
    className: "DocSearch-Reset",
    hidden: !props.state.query,
    onClick: onReset
  }, /*#__PURE__*/React.createElement(ResetIcon, null))), /*#__PURE__*/React.createElement("button", {
    className: "DocSearch-Cancel",
    onClick: props.onClose
  }, "Cancel"));
}