function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from 'react';
import { RecentIcon, ResetIcon, StarIcon } from './icons';
import { Results } from './Results';
export function StartScreen(props) {
  if (props.state.status === 'idle' && props.hasSuggestions === false) {
    if (props.disableUserPersonalization) {
      return null;
    }

    return /*#__PURE__*/React.createElement("div", {
      className: "DocSearch-StartScreen"
    }, /*#__PURE__*/React.createElement("p", {
      className: "DocSearch-Help"
    }, "No recent searches"));
  }

  if (props.hasSuggestions === false) {
    return null;
  }

  return /*#__PURE__*/React.createElement("div", {
    className: "DocSearch-Dropdown-Container"
  }, /*#__PURE__*/React.createElement(Results, _extends({}, props, {
    title: "Recent",
    suggestion: props.state.suggestions[0],
    renderIcon: function renderIcon() {
      return /*#__PURE__*/React.createElement("div", {
        className: "DocSearch-Hit-icon"
      }, /*#__PURE__*/React.createElement(RecentIcon, null));
    },
    renderAction: function renderAction(_ref) {
      var item = _ref.item,
          runFavoriteTransition = _ref.runFavoriteTransition,
          runDeleteTransition = _ref.runDeleteTransition;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
        className: "DocSearch-Hit-action"
      }, /*#__PURE__*/React.createElement("button", {
        className: "DocSearch-Hit-action-button",
        title: "Save this search",
        onClick: function onClick(event) {
          event.preventDefault();
          event.stopPropagation();
          runFavoriteTransition(function () {
            props.favoriteSearches.add(item);
            props.recentSearches.remove(item);
            props.refresh();
          });
        }
      }, /*#__PURE__*/React.createElement(StarIcon, null))), /*#__PURE__*/React.createElement("div", {
        className: "DocSearch-Hit-action"
      }, /*#__PURE__*/React.createElement("button", {
        className: "DocSearch-Hit-action-button",
        title: "Remove this search from history",
        onClick: function onClick(event) {
          event.preventDefault();
          event.stopPropagation();
          runDeleteTransition(function () {
            props.recentSearches.remove(item);
            props.refresh();
          });
        }
      }, /*#__PURE__*/React.createElement(ResetIcon, null))));
    }
  })), /*#__PURE__*/React.createElement(Results, _extends({}, props, {
    title: "Favorites",
    suggestion: props.state.suggestions[1],
    renderIcon: function renderIcon() {
      return /*#__PURE__*/React.createElement("div", {
        className: "DocSearch-Hit-icon"
      }, /*#__PURE__*/React.createElement(StarIcon, null));
    },
    renderAction: function renderAction(_ref2) {
      var item = _ref2.item,
          runDeleteTransition = _ref2.runDeleteTransition;
      return /*#__PURE__*/React.createElement("div", {
        className: "DocSearch-Hit-action"
      }, /*#__PURE__*/React.createElement("button", {
        className: "DocSearch-Hit-action-button",
        title: "Remove this search from favorites",
        onClick: function onClick(event) {
          event.preventDefault();
          event.stopPropagation();
          runDeleteTransition(function () {
            props.favoriteSearches.remove(item);
            props.refresh();
          });
        }
      }, /*#__PURE__*/React.createElement(ResetIcon, null)));
    }
  })));
}