/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { RouteConfig, OnBrokenLinks } from '@docusaurus/types';
declare type BrokenLink = {
    link: string;
    resolvedLink: string;
};
export declare function getAllBrokenLinks({ allCollectedLinks, routes, }: {
    allCollectedLinks: Record<string, string[]>;
    routes: RouteConfig[];
}): Record<string, BrokenLink[]>;
export declare function getBrokenLinksErrorMessage(allBrokenLinks: Record<string, BrokenLink[]>): string | undefined;
export declare function handleBrokenLinks({ allCollectedLinks, onBrokenLinks, routes, baseUrl, outDir, }: {
    allCollectedLinks: Record<string, string[]>;
    onBrokenLinks: OnBrokenLinks;
    routes: RouteConfig[];
    baseUrl: string;
    outDir: string;
}): Promise<void>;
export {};
//# sourceMappingURL=brokenLinks.d.ts.map