"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const module_1 = __importDefault(require("module"));
const path_1 = require("path");
const import_fresh_1 = __importDefault(require("import-fresh"));
const constants_1 = require("../../constants");
const versions_1 = require("../versions");
const pluginIds_1 = require("./pluginIds");
const Joi = __importStar(require("@hapi/joi"));
function pluginOptionsValidator(schema, options) {
    // All plugins can be provided an "id" for multi-instance support
    // we don't ask the user to implement id validation, we add it automatically
    const finalSchema = schema.append({
        id: Joi.string(),
    });
    const { error, value } = finalSchema.validate(options, {
        convert: false,
    });
    if (error) {
        throw error;
    }
    return value;
}
function themeConfigValidator(schema, options) {
    // A theme should only validate his "slice" of the full themeConfig,
    // not the whole object, so we allow unknown attributes to pass a theme validation
    const finalSchema = schema.unknown();
    const { error, value } = finalSchema.validate(options, {
        convert: false,
    });
    if (error) {
        throw error;
    }
    return value;
}
function initPlugins({ pluginConfigs, context, }) {
    // We need to resolve plugins from the perspective of the siteDir, since the siteDir's package.json
    // declares the dependency on these plugins.
    // We need to fallback to createRequireFromPath since createRequire is only available in node v12.
    // See: https://nodejs.org/api/modules.html#modules_module_createrequire_filename
    const createRequire = module_1.default.createRequire || module_1.default.createRequireFromPath;
    const pluginRequire = createRequire(path_1.join(context.siteDir, constants_1.CONFIG_FILE_NAME));
    const plugins = pluginConfigs
        .map((pluginItem) => {
        var _a, _b, _c, _d;
        let pluginModuleImport;
        let pluginOptions = {};
        if (!pluginItem) {
            return null;
        }
        if (typeof pluginItem === 'string') {
            pluginModuleImport = pluginItem;
        }
        else if (Array.isArray(pluginItem)) {
            [pluginModuleImport, pluginOptions = {}] = pluginItem;
        }
        if (!pluginModuleImport) {
            return null;
        }
        // The pluginModuleImport value is any valid
        // module identifier - npm package or locally-resolved path.
        const pluginPath = pluginRequire.resolve(pluginModuleImport);
        const pluginModule = import_fresh_1.default(pluginPath);
        const pluginVersion = versions_1.getPluginVersion(pluginPath, context.siteDir);
        const plugin = pluginModule.default || pluginModule;
        // support both commonjs and ES modules
        const validateOptions = (_b = (_a = pluginModule.default) === null || _a === void 0 ? void 0 : _a.validateOptions) !== null && _b !== void 0 ? _b : pluginModule.validateOptions;
        if (validateOptions) {
            const normalizedOptions = validateOptions({
                validate: pluginOptionsValidator,
                options: pluginOptions,
            });
            pluginOptions = normalizedOptions;
        }
        // support both commonjs and ES modules
        const validateThemeConfig = (_d = (_c = pluginModule.default) === null || _c === void 0 ? void 0 : _c.validateThemeConfig) !== null && _d !== void 0 ? _d : pluginModule.validateThemeConfig;
        if (validateThemeConfig) {
            const normalizedThemeConfig = validateThemeConfig({
                validate: themeConfigValidator,
                themeConfig: context.siteConfig.themeConfig,
            });
            context.siteConfig.themeConfig = Object.assign(Object.assign({}, context.siteConfig.themeConfig), normalizedThemeConfig);
        }
        return Object.assign(Object.assign({}, plugin(context, pluginOptions)), { options: pluginOptions, version: pluginVersion });
    })
        .filter(Boolean);
    pluginIds_1.ensureUniquePluginInstanceIds(plugins);
    return plugins;
}
exports.default = initPlugins;
