"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const alias_1 = __importDefault(require("./alias"));
function loadThemeAlias(themePaths, userThemePaths = []) {
    const aliases = {};
    themePaths.forEach((themePath) => {
        const themeAliases = alias_1.default(themePath);
        Object.keys(themeAliases).forEach((aliasKey) => {
            if (aliasKey in aliases) {
                const componentName = aliasKey.substring(aliasKey.indexOf('/') + 1);
                aliases[`@theme-init/${componentName}`] = aliases[aliasKey];
            }
            aliases[aliasKey] = themeAliases[aliasKey];
        });
    });
    userThemePaths.forEach((themePath) => {
        const userThemeAliases = alias_1.default(themePath, false);
        Object.keys(userThemeAliases).forEach((aliasKey) => {
            aliases[aliasKey] = userThemeAliases[aliasKey];
        });
    });
    return aliases;
}
exports.default = loadThemeAlias;
