/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { hydrate, render } from 'react-dom';
import { BrowserRouter } from 'react-router-dom';
import routes from '@generated/routes';
import ExecutionEnvironment from './exports/ExecutionEnvironment';
import App from './App';
import preload from './preload';
import docusaurus from './docusaurus';
// Client-side render (e.g: running in browser) to become single-page application (SPA).
if (ExecutionEnvironment.canUseDOM) {
    window.docusaurus = docusaurus;
    // For production, attempt to hydrate existing markup for performant first-load experience.
    // For development, there is no existing markup so we had to render it.
    // Note that we also preload async component to avoid first-load loading screen.
    const renderMethod = process.env.NODE_ENV === 'production' ? hydrate : render;
    preload(routes, window.location.pathname).then(() => {
        renderMethod(React.createElement(BrowserRouter, null,
            React.createElement(App, null)), document.getElementById('__docusaurus'));
    });
    // Webpack Hot Module Replacement API
    if (module.hot) {
        // Self-accepting method/ trick
        // (https://github.com/webpack/webpack-dev-server/issues/100#issuecomment-290911036)
        module.hot.accept();
    }
}
