/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { useEffect, useRef } from 'react';
import { NavLink, Link as RRLink } from 'react-router-dom';
import isInternalUrl from './isInternalUrl';
import ExecutionEnvironment from './ExecutionEnvironment';
import { useLinksCollector } from '../LinksCollector';
import { useBaseUrlUtils } from './useBaseUrl';
function Link(_a) {
    var _b;
    var { isNavLink, to, href, activeClassName, 'data-noBrokenLinkCheck': noBrokenLinkCheck } = _a, props = __rest(_a, ["isNavLink", "to", "href", "activeClassName", 'data-noBrokenLinkCheck']);
    const { withBaseUrl } = useBaseUrlUtils();
    const linksCollector = useLinksCollector();
    // IMPORTANT: using to or href should not change anything
    // For example, MDX links will ALWAYS give us the href props
    // Using one prop or the other should not be used to distinguish
    // internal links (/docs/myDoc) from external links (https://github.com)
    const targetLinkUnprefixed = to || href;
    // Automatically apply base url in links
    const targetLink = typeof targetLinkUnprefixed !== 'undefined'
        ? withBaseUrl(targetLinkUnprefixed)
        : undefined;
    const isInternal = isInternalUrl(targetLink);
    const preloaded = useRef(false);
    const LinkComponent = isNavLink ? NavLink : RRLink;
    const IOSupported = ExecutionEnvironment.canUseIntersectionObserver;
    let io;
    const handleIntersection = (el, cb) => {
        io = new window.IntersectionObserver((entries) => {
            entries.forEach((entry) => {
                if (el === entry.target) {
                    // If element is in viewport, stop listening/observing and run callback.
                    // https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API
                    if (entry.isIntersecting || entry.intersectionRatio > 0) {
                        io.unobserve(el);
                        io.disconnect();
                        cb();
                    }
                }
            });
        });
        // Add element to the observer.
        io.observe(el);
    };
    const handleRef = (ref) => {
        if (IOSupported && ref && isInternal) {
            // If IO supported and element reference found, setup Observer functionality.
            handleIntersection(ref, () => {
                window.docusaurus.prefetch(targetLink);
            });
        }
    };
    const onMouseEnter = () => {
        if (!preloaded.current) {
            window.docusaurus.preload(targetLink);
            preloaded.current = true;
        }
    };
    useEffect(() => {
        // If IO is not supported. We prefetch by default (only once).
        if (!IOSupported && isInternal) {
            window.docusaurus.prefetch(targetLink);
        }
        // When unmounting, stop intersection observer from watching.
        return () => {
            if (IOSupported && io) {
                io.disconnect();
            }
        };
    }, [targetLink, IOSupported, isInternal]);
    const isAnchorLink = (_b = targetLink === null || targetLink === void 0 ? void 0 : targetLink.startsWith('#')) !== null && _b !== void 0 ? _b : false;
    const isRegularHtmlLink = !targetLink || !isInternal || isAnchorLink;
    if (targetLink && isInternal && !isAnchorLink && !noBrokenLinkCheck) {
        linksCollector.collectLink(targetLink);
    }
    return isRegularHtmlLink ? (
    // eslint-disable-next-line jsx-a11y/anchor-has-content
    React.createElement("a", Object.assign({ href: targetLink }, (!isInternal && { target: '_blank', rel: 'noopener noreferrer' }), props))) : (React.createElement(LinkComponent, Object.assign({}, props, { onMouseEnter: onMouseEnter, innerRef: handleRef, to: targetLink }, (isNavLink && { activeClassName }))));
}
export default Link;
