"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const server_1 = require("../server");
const init_1 = __importDefault(require("../server/plugins/init"));
function externalCommand(cli, siteDir) {
    const context = server_1.loadContext(siteDir);
    const pluginConfigs = server_1.loadPluginConfigs(context);
    const plugins = init_1.default({ pluginConfigs, context });
    // Plugin Lifecycle - extendCli.
    plugins.forEach((plugin) => {
        const { extendCli } = plugin;
        if (!extendCli) {
            return;
        }
        extendCli(cli);
    });
}
exports.default = externalCommand;
