"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chalk = require("chalk");
const fs_extra_1 = __importDefault(require("fs-extra"));
const import_fresh_1 = __importDefault(require("import-fresh"));
const path_1 = __importDefault(require("path"));
const constants_1 = require("../constants");
const server_1 = require("../server");
async function swizzle(siteDir, themeName, componentName, typescript) {
    var _a, _b;
    const plugin = import_fresh_1.default(themeName);
    const context = server_1.loadContext(siteDir);
    const pluginInstance = plugin(context);
    let fromPath = typescript
        ? (_a = pluginInstance.getTypeScriptThemePath) === null || _a === void 0 ? void 0 : _a.call(pluginInstance) : (_b = pluginInstance.getThemePath) === null || _b === void 0 ? void 0 : _b.call(pluginInstance);
    if (fromPath) {
        let toPath = path_1.default.resolve(siteDir, constants_1.THEME_PATH);
        if (componentName) {
            fromPath = path_1.default.join(fromPath, componentName);
            toPath = path_1.default.join(toPath, componentName);
            // Handle single TypeScript/JavaScript file only.
            // E.g: if <fromPath> does not exist, we try to swizzle <fromPath>.(ts|tsx|js) instead
            if (!fs_extra_1.default.existsSync(fromPath)) {
                if (fs_extra_1.default.existsSync(`${fromPath}.ts`)) {
                    [fromPath, toPath] = [`${fromPath}.ts`, `${toPath}.ts`];
                }
                else if (fs_extra_1.default.existsSync(`${fromPath}.tsx`)) {
                    [fromPath, toPath] = [`${fromPath}.tsx`, `${toPath}.tsx`];
                }
                else if (fs_extra_1.default.existsSync(`${fromPath}.js`)) {
                    [fromPath, toPath] = [`${fromPath}.js`, `${toPath}.js`];
                }
            }
        }
        await fs_extra_1.default.copy(fromPath, toPath);
        const relativeDir = path_1.default.relative(process.cwd(), toPath);
        const fromMsg = chalk.blue(componentName ? `${themeName} ${chalk.yellow(componentName)}` : themeName);
        const toMsg = chalk.cyan(relativeDir);
        console.log(`\n${chalk.green('Success!')} Copied ${fromMsg} to ${toMsg}.\n`);
    }
    else if (typescript) {
        console.warn(chalk.yellow(`${themeName} does not provide TypeScript theme code via getTypeScriptThemePath().`));
    }
    else {
        console.warn(chalk.yellow(`${themeName} does not provide any theme code.`));
    }
}
exports.default = swizzle;
