"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const http_1 = __importDefault(require("http"));
const serve_handler_1 = __importDefault(require("serve-handler"));
const boxen_1 = __importDefault(require("boxen"));
const chalk_1 = __importDefault(require("chalk"));
const path_1 = __importDefault(require("path"));
const build_1 = __importDefault(require("./build"));
const choosePort_1 = __importDefault(require("../choosePort"));
async function serve(siteDir, cliOptions) {
    let dir = path_1.default.join(siteDir, cliOptions.dir);
    if (cliOptions.build) {
        dir = await build_1.default(siteDir, {
            outDir: dir,
        }, false);
    }
    const port = await choosePort_1.default(cliOptions.host, cliOptions.port);
    const server = http_1.default.createServer((req, res) => {
        serve_handler_1.default(req, res, {
            cleanUrls: true,
            public: dir,
        });
    });
    console.log(boxen_1.default(`${chalk_1.default.green(`Serving ${cliOptions.dir}!`)}\n\n- Local: http://${cliOptions.host}:${port}`, {
        borderColor: 'green',
        padding: 1,
        margin: 1,
        align: 'center',
    }));
    server.listen(port);
}
exports.default = serve;
