"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportMessage = exports.getAllFinalRoutes = void 0;
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const chalk_1 = __importDefault(require("chalk"));
const lodash_flatmap_1 = __importDefault(require("lodash.flatmap"));
// Recursively get the final routes (routes with no subroutes)
function getAllFinalRoutes(routeConfig) {
    function getFinalRoutes(route) {
        return route.routes ? lodash_flatmap_1.default(route.routes, getFinalRoutes) : [route];
    }
    return lodash_flatmap_1.default(routeConfig, getFinalRoutes);
}
exports.getAllFinalRoutes = getAllFinalRoutes;
function reportMessage(message, reportingSeverity) {
    switch (reportingSeverity) {
        case 'ignore':
            break;
        case 'log':
            console.log(chalk_1.default.bold.blue('info ') + chalk_1.default.blue(message));
            break;
        case 'warn':
            console.warn(chalk_1.default.bold.yellow('warn ') + chalk_1.default.yellow(message));
            break;
        case 'error':
            console.error(chalk_1.default.bold.red('error ') + chalk_1.default.red(message));
            break;
        case 'throw':
            throw new Error(message);
        default:
            throw new Error(`unexpected reportingSeverity value: ${reportingSeverity}`);
    }
}
exports.reportMessage = reportMessage;
