"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const static_site_generator_webpack_plugin_1 = __importDefault(require("@endiliey/static-site-generator-webpack-plugin"));
const webpack_merge_1 = __importDefault(require("webpack-merge"));
const base_1 = require("./base");
const WaitPlugin_1 = __importDefault(require("./plugins/WaitPlugin"));
const LogPlugin_1 = __importDefault(require("./plugins/LogPlugin"));
function createServerConfig({ props, minify = true, onLinksCollected = () => { }, }) {
    const { baseUrl, routesPaths, generatedFilesDir, headTags, preBodyTags, postBodyTags, ssrTemplate, } = props;
    const config = base_1.createBaseConfig(props, true, minify);
    const routesLocation = {};
    // Array of paths to be rendered. Relative to output directory
    const ssgPaths = routesPaths.map((str) => {
        const ssgPath = baseUrl === '/' ? str : str.replace(new RegExp(`^${baseUrl}`), '/');
        routesLocation[ssgPath] = str;
        return ssgPath;
    });
    const serverConfig = webpack_merge_1.default(config, {
        entry: {
            main: path_1.default.resolve(__dirname, '../client/serverEntry.js'),
        },
        output: {
            filename: 'server.bundle.js',
            libraryTarget: 'commonjs2',
            // Workaround for Webpack 4 Bug (https://github.com/webpack/webpack/issues/6522)
            globalObject: 'this',
        },
        target: 'node',
        plugins: [
            // Wait until manifest from client bundle is generated
            new WaitPlugin_1.default({
                filepath: path_1.default.join(generatedFilesDir, 'client-manifest.json'),
            }),
            // Static site generator webpack plugin.
            new static_site_generator_webpack_plugin_1.default({
                entry: 'main',
                locals: {
                    baseUrl,
                    generatedFilesDir,
                    routesLocation,
                    headTags,
                    preBodyTags,
                    postBodyTags,
                    onLinksCollected,
                    ssrTemplate,
                },
                paths: ssgPaths,
            }),
            // Show compilation progress bar.
            new LogPlugin_1.default({
                name: 'Server',
                color: 'yellow',
            }),
        ],
    });
    return serverConfig;
}
exports.default = createServerConfig;
