"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const import_fresh_1 = __importDefault(require("import-fresh"));
function loadPresets(context) {
    const presets = (context.siteConfig || {}).presets || [];
    const unflatPlugins = [];
    const unflatThemes = [];
    presets.forEach((presetItem) => {
        let presetModuleImport;
        let presetOptions = {};
        if (typeof presetItem === 'string') {
            presetModuleImport = presetItem;
        }
        else if (Array.isArray(presetItem)) {
            [presetModuleImport, presetOptions = {}] = presetItem;
        }
        else {
            throw new Error('Invalid presets format detected in config.');
        }
        const presetModule = import_fresh_1.default(presetModuleImport);
        const preset = (presetModule.default || presetModule)(context, presetOptions);
        if (preset.plugins) {
            unflatPlugins.push(preset.plugins);
        }
        if (preset.themes) {
            unflatThemes.push(preset.themes);
        }
    });
    return {
        plugins: [].concat(...unflatPlugins).filter(Boolean),
        themes: [].concat(...unflatThemes).filter(Boolean),
    };
}
exports.default = loadPresets;
