"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const blogUtils_1 = require("./blogUtils");
const loader_utils_1 = require("loader-utils");
const markdownLoader = function (source) {
    const fileString = source;
    const callback = this.async();
    const { truncateMarker, siteDir, contentPath, blogPosts } = loader_utils_1.getOptions(this);
    // Linkify posts
    let finalContent = blogUtils_1.linkify(fileString, siteDir, contentPath, blogPosts);
    // Truncate content if requested (e.g: file.md?truncated=true).
    const truncated = this.resourceQuery
        ? loader_utils_1.parseQuery(this.resourceQuery).truncated
        : undefined;
    if (truncated) {
        finalContent = blogUtils_1.truncate(finalContent, truncateMarker);
    }
    return callback && callback(null, finalContent);
};
exports.default = markdownLoader;
