"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginOptionSchema = exports.DEFAULT_OPTIONS = void 0;
const Joi = __importStar(require("@hapi/joi"));
const utils_validation_1 = require("@docusaurus/utils-validation");
exports.DEFAULT_OPTIONS = {
    feedOptions: {},
    beforeDefaultRehypePlugins: [],
    beforeDefaultRemarkPlugins: [],
    admonitions: {},
    truncateMarker: /<!--\s*(truncate)\s*-->/,
    rehypePlugins: [],
    remarkPlugins: [],
    showReadingTime: true,
    blogTagsPostsComponent: '@theme/BlogTagsPostsPage',
    blogTagsListComponent: '@theme/BlogTagsListPage',
    blogPostComponent: '@theme/BlogPostPage',
    blogListComponent: '@theme/BlogListPage',
    blogDescription: 'Blog',
    postsPerPage: 10,
    include: ['*.md', '*.mdx'],
    routeBasePath: 'blog',
    path: 'blog',
};
exports.PluginOptionSchema = Joi.object({
    path: Joi.string().default(exports.DEFAULT_OPTIONS.path),
    routeBasePath: Joi.string()
        // '' not allowed, see https://github.com/facebook/docusaurus/issues/3374
        // .allow('')
        .default(exports.DEFAULT_OPTIONS.routeBasePath),
    include: Joi.array().items(Joi.string()).default(exports.DEFAULT_OPTIONS.include),
    postsPerPage: Joi.number()
        .integer()
        .min(1)
        .default(exports.DEFAULT_OPTIONS.postsPerPage),
    blogListComponent: Joi.string().default(exports.DEFAULT_OPTIONS.blogListComponent),
    blogPostComponent: Joi.string().default(exports.DEFAULT_OPTIONS.blogPostComponent),
    blogTagsListComponent: Joi.string().default(exports.DEFAULT_OPTIONS.blogTagsListComponent),
    blogTagsPostsComponent: Joi.string().default(exports.DEFAULT_OPTIONS.blogTagsPostsComponent),
    blogDescription: Joi.string()
        .allow('')
        .default(exports.DEFAULT_OPTIONS.blogDescription),
    showReadingTime: Joi.bool().default(exports.DEFAULT_OPTIONS.showReadingTime),
    remarkPlugins: utils_validation_1.RemarkPluginsSchema.default(exports.DEFAULT_OPTIONS.remarkPlugins),
    rehypePlugins: utils_validation_1.RehypePluginsSchema.default(exports.DEFAULT_OPTIONS.rehypePlugins),
    admonitions: utils_validation_1.AdmonitionsSchema.default(exports.DEFAULT_OPTIONS.admonitions),
    editUrl: utils_validation_1.URISchema,
    truncateMarker: Joi.object().default(exports.DEFAULT_OPTIONS.truncateMarker),
    beforeDefaultRemarkPlugins: utils_validation_1.RemarkPluginsSchema.default(exports.DEFAULT_OPTIONS.beforeDefaultRemarkPlugins),
    beforeDefaultRehypePlugins: utils_validation_1.RehypePluginsSchema.default(exports.DEFAULT_OPTIONS.beforeDefaultRehypePlugins),
    feedOptions: Joi.object({
        type: Joi.alternatives().conditional(Joi.string().equal('all', 'rss', 'atom'), {
            then: Joi.custom((val) => (val === 'all' ? ['rss', 'atom'] : [val])),
        }),
        title: Joi.string().allow(''),
        description: Joi.string().allow(''),
        copyright: Joi.string(),
        language: Joi.string(),
    }).default(exports.DEFAULT_OPTIONS.feedOptions),
});
