/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Sidebars, SidebarItemDoc, Sidebar } from './types';
export declare function loadSidebars(sidebarFilePath: string): Sidebars;
export declare function collectSidebarDocItems(sidebar: Sidebar): SidebarItemDoc[];
export declare function collectSidebarsDocIds(sidebars: Sidebars): Record<string, string[]>;
export declare function createSidebarsUtils(sidebars: Sidebars): {
    getFirstDocIdOfFirstSidebar: () => string | undefined;
    getSidebarNameByDocId: (docId: string) => string | undefined;
    getDocNavigation: (docId: string) => {
        sidebarName: string | undefined;
        previousId: string | undefined;
        nextId: string | undefined;
    };
    checkSidebarsDocIds: (validDocIds: string[]) => void;
};
//# sourceMappingURL=sidebars.d.ts.map