"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("@docusaurus/utils");
function getSlug({ baseID, frontmatterSlug, dirName, }) {
    const baseSlug = frontmatterSlug || baseID;
    let slug;
    if (baseSlug.startsWith('/')) {
        slug = baseSlug;
    }
    else {
        const resolveDirname = dirName === '.' ? '/' : utils_1.addLeadingSlash(utils_1.addTrailingSlash(dirName));
        slug = utils_1.resolvePathname(baseSlug, resolveDirname);
    }
    if (!utils_1.isValidPathname(slug)) {
        throw new Error(`We couldn't compute a valid slug for document with id=${baseID} in folder=${dirName}
The slug we computed looks invalid: ${slug}
Maybe your slug frontmatter is incorrect or you use weird chars in the file path?
By using the slug frontmatter, you should be able to fix this error, by using the slug of your choice:

Example =>
---
slug: /my/customDocPath
---
`);
    }
    return slug;
}
exports.default = getSlug;
