"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateOptions = exports.OptionsSchema = exports.DEFAULT_OPTIONS = void 0;
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const Joi = __importStar(require("@hapi/joi"));
const utils_validation_1 = require("@docusaurus/utils-validation");
const chalk_1 = __importDefault(require("chalk"));
const remark_admonitions_1 = __importDefault(require("remark-admonitions"));
exports.DEFAULT_OPTIONS = {
    path: 'docs',
    routeBasePath: 'docs',
    homePageId: undefined,
    include: ['**/*.{md,mdx}'],
    sidebarPath: 'sidebars.json',
    docLayoutComponent: '@theme/DocPage',
    docItemComponent: '@theme/DocItem',
    remarkPlugins: [],
    rehypePlugins: [],
    showLastUpdateTime: false,
    showLastUpdateAuthor: false,
    admonitions: {},
    excludeNextVersionDocs: false,
    includeCurrentVersion: true,
    disableVersioning: false,
    lastVersion: undefined,
    versions: {},
};
const VersionOptionsSchema = Joi.object({
    path: Joi.string().allow('').optional(),
    label: Joi.string().optional(),
});
const VersionsOptionsSchema = Joi.object()
    .pattern(Joi.string().required(), VersionOptionsSchema)
    .default(exports.DEFAULT_OPTIONS.versions);
exports.OptionsSchema = Joi.object({
    path: Joi.string().default(exports.DEFAULT_OPTIONS.path),
    editUrl: utils_validation_1.URISchema,
    routeBasePath: Joi.string()
        // '' not allowed, see https://github.com/facebook/docusaurus/issues/3374
        // .allow('') ""
        .default(exports.DEFAULT_OPTIONS.routeBasePath),
    homePageId: Joi.string().optional(),
    include: Joi.array().items(Joi.string()).default(exports.DEFAULT_OPTIONS.include),
    sidebarPath: Joi.string().allow('').default(exports.DEFAULT_OPTIONS.sidebarPath),
    docLayoutComponent: Joi.string().default(exports.DEFAULT_OPTIONS.docLayoutComponent),
    docItemComponent: Joi.string().default(exports.DEFAULT_OPTIONS.docItemComponent),
    remarkPlugins: utils_validation_1.RemarkPluginsSchema.default(exports.DEFAULT_OPTIONS.remarkPlugins),
    rehypePlugins: utils_validation_1.RehypePluginsSchema.default(exports.DEFAULT_OPTIONS.rehypePlugins),
    admonitions: utils_validation_1.AdmonitionsSchema.default(exports.DEFAULT_OPTIONS.admonitions),
    showLastUpdateTime: Joi.bool().default(exports.DEFAULT_OPTIONS.showLastUpdateTime),
    showLastUpdateAuthor: Joi.bool().default(exports.DEFAULT_OPTIONS.showLastUpdateAuthor),
    excludeNextVersionDocs: Joi.bool().default(exports.DEFAULT_OPTIONS.excludeNextVersionDocs),
    includeCurrentVersion: Joi.bool().default(exports.DEFAULT_OPTIONS.includeCurrentVersion),
    onlyIncludeVersions: Joi.array().items(Joi.string().required()).optional(),
    disableVersioning: Joi.bool().default(exports.DEFAULT_OPTIONS.disableVersioning),
    lastVersion: Joi.string().optional(),
    versions: VersionsOptionsSchema,
});
// TODO bad validation function types
function validateOptions({ validate, options, }) {
    // TODO remove homePageId before end of 2020
    // "slug: /" is better because the home doc can be different across versions
    if (options.homePageId) {
        console.log(chalk_1.default.red(`The docs plugin option homePageId=${options.homePageId} is deprecated. To make a doc the "home", prefer frontmatter: "slug: /"`));
    }
    if (typeof options.excludeNextVersionDocs !== 'undefined') {
        console.log(chalk_1.default.red(`The docs plugin option excludeNextVersionDocs=${options.excludeNextVersionDocs} is deprecated. Use the includeCurrentVersion=${!options.excludeNextVersionDocs} option instead!"`));
        options.includeCurrentVersion = !options.excludeNextVersionDocs;
    }
    // @ts-expect-error: TODO bad OptionValidationContext, need refactor
    const normalizedOptions = validate(exports.OptionsSchema, options);
    if (normalizedOptions.admonitions) {
        normalizedOptions.remarkPlugins = normalizedOptions.remarkPlugins.concat([
            [remark_admonitions_1.default, normalizedOptions.admonitions],
        ]);
    }
    // @ts-expect-error: TODO bad OptionValidationContext, need refactor
    return normalizedOptions;
}
exports.validateOptions = validateOptions;
