/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
export declare type DocFile = {
    source: string;
    content: string;
    lastUpdate: LastUpdateData;
};
export declare type VersionName = string;
export declare type VersionMetadata = {
    versionName: VersionName;
    versionLabel: string;
    versionPath: string;
    isLast: boolean;
    docsDirPath: string;
    sidebarFilePath: string;
    routePriority: number | undefined;
};
export declare type MetadataOptions = {
    routeBasePath: string;
    homePageId?: string;
    editUrl?: string;
    showLastUpdateTime?: boolean;
    showLastUpdateAuthor?: boolean;
};
export declare type PathOptions = {
    path: string;
    sidebarPath: string;
};
export declare type VersionOptions = {
    path?: string;
    label?: string;
};
export declare type VersionsOptions = {
    lastVersion?: string;
    versions: Record<string, VersionOptions>;
    onlyIncludeVersions?: string[];
};
export declare type PluginOptions = MetadataOptions & PathOptions & VersionsOptions & {
    id: string;
    include: string[];
    docLayoutComponent: string;
    docItemComponent: string;
    remarkPlugins: ([Function, object] | Function)[];
    rehypePlugins: string[];
    admonitions: any;
    disableVersioning: boolean;
    excludeNextVersionDocs?: boolean;
    includeCurrentVersion: boolean;
};
export declare type SidebarItemDoc = {
    type: 'doc' | 'ref';
    id: string;
};
export declare type SidebarItemLink = {
    type: 'link';
    href: string;
    label: string;
};
export declare type SidebarItemCategory = {
    type: 'category';
    label: string;
    items: SidebarItem[];
    collapsed: boolean;
};
export declare type SidebarItem = SidebarItemDoc | SidebarItemLink | SidebarItemCategory;
export declare type Sidebar = SidebarItem[];
export declare type Sidebars = Record<string, Sidebar>;
export declare type OrderMetadata = {
    previous?: string;
    next?: string;
    sidebar?: string;
};
export declare type LastUpdateData = {
    lastUpdatedAt?: number;
    lastUpdatedBy?: string;
};
export declare type DocMetadataBase = LastUpdateData & {
    version: VersionName;
    unversionedId: string;
    id: string;
    isDocsHomePage: boolean;
    title: string;
    description: string;
    source: string;
    slug: string;
    permalink: string;
    sidebar_label?: string;
    editUrl?: string | null;
};
export declare type DocNavLink = {
    title: string;
    permalink: string;
};
export declare type DocMetadata = DocMetadataBase & {
    sidebar?: string;
    previous?: DocNavLink;
    next?: DocNavLink;
};
export declare type SourceToPermalink = {
    [source: string]: string;
};
export declare type LoadedVersion = VersionMetadata & {
    versionPath: string;
    mainDocId: string;
    docs: DocMetadata[];
    sidebars: Sidebars;
    permalinkToSidebar: Record<string, string>;
};
export declare type LoadedContent = {
    loadedVersions: LoadedVersion[];
};
export declare type GlobalDoc = {
    id: string;
    path: string;
};
export declare type GlobalVersion = {
    name: VersionName;
    label: string;
    isLast: boolean;
    path: string;
    mainDocId: string;
    docs: GlobalDoc[];
};
export declare type GlobalPluginData = {
    path: string;
    versions: GlobalVersion[];
};
export declare type BrokenMarkdownLink = {
    filePath: string;
    version: VersionMetadata;
    link: string;
};
export declare type DocsMarkdownOption = {
    versionsMetadata: VersionMetadata[];
    siteDir: string;
    sourceToPermalink: SourceToPermalink;
    onBrokenMarkdownLink: (brokenMarkdownLink: BrokenMarkdownLink) => void;
};
//# sourceMappingURL=types.d.ts.map