/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { PluginOptions, VersionMetadata } from './types';
import { LoadContext } from '@docusaurus/types';
export declare function getVersionedDocsDirPath(siteDir: string, pluginId: string): string;
export declare function getVersionedSidebarsDirPath(siteDir: string, pluginId: string): string;
export declare function getVersionsFilePath(siteDir: string, pluginId: string): string;
export declare function readVersionsMetadata({ context, options, }: {
    context: Pick<LoadContext, 'siteDir' | 'baseUrl'>;
    options: Pick<PluginOptions, 'id' | 'path' | 'sidebarPath' | 'routeBasePath' | 'includeCurrentVersion' | 'disableVersioning' | 'lastVersion' | 'versions' | 'onlyIncludeVersions'>;
}): VersionMetadata[];
//# sourceMappingURL=versions.d.ts.map