"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginOptionSchema = exports.DEFAULT_OPTIONS = void 0;
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const Joi = __importStar(require("@hapi/joi"));
const utils_validation_1 = require("@docusaurus/utils-validation");
exports.DEFAULT_OPTIONS = {
    path: 'src/pages',
    routeBasePath: '/',
    include: ['**/*.{js,jsx,ts,tsx,md,mdx}'],
    mdxPageComponent: '@theme/MDXPage',
    remarkPlugins: [],
    rehypePlugins: [],
    admonitions: {},
    exclude: [
        '**/_*.{js,jsx,ts,tsx,md,mdx}',
        '**/*.test.{js,ts}',
        '**/__tests__/**',
    ],
};
exports.PluginOptionSchema = Joi.object({
    path: Joi.string().default(exports.DEFAULT_OPTIONS.path),
    routeBasePath: Joi.string().default(exports.DEFAULT_OPTIONS.routeBasePath),
    include: Joi.array().items(Joi.string()).default(exports.DEFAULT_OPTIONS.include),
    exclude: Joi.array().items(Joi.string()).default(exports.DEFAULT_OPTIONS.exclude),
    mdxPageComponent: Joi.string().default(exports.DEFAULT_OPTIONS.mdxPageComponent),
    remarkPlugins: utils_validation_1.RemarkPluginsSchema.default(exports.DEFAULT_OPTIONS.remarkPlugins),
    rehypePlugins: utils_validation_1.RehypePluginsSchema.default(exports.DEFAULT_OPTIONS.rehypePlugins),
    admonitions: utils_validation_1.AdmonitionsSchema.default(exports.DEFAULT_OPTIONS.admonitions),
});
