"use strict";
/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const sitemap_1 = __importDefault(require("sitemap"));
function createSitemap(siteConfig, routesPaths, options) {
    const { url: hostname } = siteConfig;
    if (!hostname) {
        throw new Error('url in docusaurus.config.js cannot be empty/undefined');
    }
    const urls = routesPaths
        .filter((route) => !route.endsWith('404.html'))
        .map((routesPath) => ({
        url: `${routesPath}${options.trailingSlash && routesPath !== '/' ? '/' : ''}`,
        changefreq: options.changefreq,
        priority: options.priority,
    }));
    return sitemap_1.default.createSitemap({
        hostname,
        cacheTime: options.cacheTime,
        urls,
    });
}
exports.default = createSitemap;
